pragma Ada_95;
pragma Source_File_Name (ada_main, Spec_File_Name => "b_gnatm.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b_gnatm.adb");
with Ada.Exceptions;

package body ada_main is
   pragma Warnings (Off);

   E334 : Short_Integer; pragma Import (Ada, E334, "gnat__spelling_checker_E");
   E148 : Short_Integer; pragma Import (Ada, E148, "system__os_lib_E");
   E014 : Short_Integer; pragma Import (Ada, E014, "system__soft_links_E");
   E227 : Short_Integer; pragma Import (Ada, E227, "gnat__byte_order_mark_E");
   E275 : Short_Integer; pragma Import (Ada, E275, "gnat__dynamic_htables_E");
   E020 : Short_Integer; pragma Import (Ada, E020, "system__exception_table_E");
   E053 : Short_Integer; pragma Import (Ada, E053, "ada__containers_E");
   E127 : Short_Integer; pragma Import (Ada, E127, "ada__io_exceptions_E");
   E091 : Short_Integer; pragma Import (Ada, E091, "ada__strings_E");
   E093 : Short_Integer; pragma Import (Ada, E093, "ada__strings__maps_E");
   E096 : Short_Integer; pragma Import (Ada, E096, "ada__strings__maps__constants_E");
   E106 : Short_Integer; pragma Import (Ada, E106, "ada__tags_E");
   E126 : Short_Integer; pragma Import (Ada, E126, "ada__streams_E");
   E060 : Short_Integer; pragma Import (Ada, E060, "interfaces__c_E");
   E312 : Short_Integer; pragma Import (Ada, E312, "interfaces__c__strings_E");
   E026 : Short_Integer; pragma Import (Ada, E026, "system__exceptions_E");
   E129 : Short_Integer; pragma Import (Ada, E129, "system__finalization_root_E");
   E124 : Short_Integer; pragma Import (Ada, E124, "ada__finalization_E");
   E131 : Short_Integer; pragma Import (Ada, E131, "system__storage_pools_E");
   E118 : Short_Integer; pragma Import (Ada, E118, "system__finalization_masters_E");
   E114 : Short_Integer; pragma Import (Ada, E114, "system__storage_pools__subpools_E");
   E058 : Short_Integer; pragma Import (Ada, E058, "ada__calendar_E");
   E070 : Short_Integer; pragma Import (Ada, E070, "ada__calendar__time_zones_E");
   E272 : Short_Integer; pragma Import (Ada, E272, "gnat__directory_operations_E");
   E165 : Short_Integer; pragma Import (Ada, E165, "system__assertions_E");
   E153 : Short_Integer; pragma Import (Ada, E153, "system__pool_global_E");
   E151 : Short_Integer; pragma Import (Ada, E151, "system__file_control_block_E");
   E142 : Short_Integer; pragma Import (Ada, E142, "system__file_io_E");
   E008 : Short_Integer; pragma Import (Ada, E008, "system__secondary_stack_E");
   E104 : Short_Integer; pragma Import (Ada, E104, "ada__strings__unbounded_E");
   E056 : Short_Integer; pragma Import (Ada, E056, "ada__directories_E");
   E157 : Short_Integer; pragma Import (Ada, E157, "system__regexp_E");
   E304 : Short_Integer; pragma Import (Ada, E304, "ada__text_io_E");
   E170 : Short_Integer; pragma Import (Ada, E170, "types_E");
   E201 : Short_Integer; pragma Import (Ada, E201, "casing_E");
   E211 : Short_Integer; pragma Import (Ada, E211, "elists_E");
   E002 : Short_Integer; pragma Import (Ada, E002, "gnatmake_E");
   E006 : Short_Integer; pragma Import (Ada, E006, "gnatvsn_E");
   E166 : Short_Integer; pragma Import (Ada, E166, "hostparm_E");
   E050 : Short_Integer; pragma Import (Ada, E050, "make_E");
   E277 : Short_Integer; pragma Import (Ada, E277, "makeusg_E");
   E213 : Short_Integer; pragma Import (Ada, E213, "nlists_E");
   E176 : Short_Integer; pragma Import (Ada, E176, "opt_E");
   E174 : Short_Integer; pragma Import (Ada, E174, "csets_E");
   E163 : Short_Integer; pragma Import (Ada, E163, "output_E");
   E197 : Short_Integer; pragma Import (Ada, E197, "rident_E");
   E196 : Short_Integer; pragma Import (Ada, E196, "sdefault_E");
   E268 : Short_Integer; pragma Import (Ada, E268, "sfn_scan_E");
   E221 : Short_Integer; pragma Import (Ada, E221, "stand_E");
   E260 : Short_Integer; pragma Import (Ada, E260, "styleg_E");
   E254 : Short_Integer; pragma Import (Ada, E254, "scng_E");
   E248 : Short_Integer; pragma Import (Ada, E248, "stylesw_E");
   E306 : Short_Integer; pragma Import (Ada, E306, "switch_E");
   E178 : Short_Integer; pragma Import (Ada, E178, "tree_io_E");
   E238 : Short_Integer; pragma Import (Ada, E238, "erroutc_E");
   E192 : Short_Integer; pragma Import (Ada, E192, "namet_E");
   E159 : Short_Integer; pragma Import (Ada, E159, "ali_E");
   E203 : Short_Integer; pragma Import (Ada, E203, "ali__util_E");
   E231 : Short_Integer; pragma Import (Ada, E231, "binderr_E");
   E161 : Short_Integer; pragma Import (Ada, E161, "butil_E");
   E185 : Short_Integer; pragma Import (Ada, E185, "fmap_E");
   E199 : Short_Integer; pragma Import (Ada, E199, "fname_E");
   E266 : Short_Integer; pragma Import (Ada, E266, "fname__sf_E");
   E250 : Short_Integer; pragma Import (Ada, E250, "fname__uf_E");
   E242 : Short_Integer; pragma Import (Ada, E242, "lib_E");
   E182 : Short_Integer; pragma Import (Ada, E182, "osint_E");
   E324 : Short_Integer; pragma Import (Ada, E324, "osint__m_E");
   E246 : Short_Integer; pragma Import (Ada, E246, "sem_aux_E");
   E225 : Short_Integer; pragma Import (Ada, E225, "sinput_E");
   E262 : Short_Integer; pragma Import (Ada, E262, "sinput__c_E");
   E223 : Short_Integer; pragma Import (Ada, E223, "snames_E");
   E207 : Short_Integer; pragma Import (Ada, E207, "aspects_E");
   E240 : Short_Integer; pragma Import (Ada, E240, "stringt_E");
   E172 : Short_Integer; pragma Import (Ada, E172, "targparm_E");
   E298 : Short_Integer; pragma Import (Ada, E298, "tempdir_E");
   E217 : Short_Integer; pragma Import (Ada, E217, "uintp_E");
   E232 : Short_Integer; pragma Import (Ada, E232, "err_vars_E");
   E236 : Short_Integer; pragma Import (Ada, E236, "errout_E");
   E234 : Short_Integer; pragma Import (Ada, E234, "restrict_E");
   E244 : Short_Integer; pragma Import (Ada, E244, "uname_E");
   E219 : Short_Integer; pragma Import (Ada, E219, "urealp_E");
   E209 : Short_Integer; pragma Import (Ada, E209, "einfo_E");
   E229 : Short_Integer; pragma Import (Ada, E229, "scans_E");
   E282 : Short_Integer; pragma Import (Ada, E282, "prj_E");
   E284 : Short_Integer; pragma Import (Ada, E284, "prj__attr_E");
   E338 : Short_Integer; pragma Import (Ada, E338, "prj__attr__pm_E");
   E302 : Short_Integer; pragma Import (Ada, E302, "prj__env_E");
   E290 : Short_Integer; pragma Import (Ada, E290, "prj__ext_E");
   E300 : Short_Integer; pragma Import (Ada, E300, "prj__tree_E");
   E279 : Short_Integer; pragma Import (Ada, E279, "makeutl_E");
   E332 : Short_Integer; pragma Import (Ada, E332, "prj__dect_E");
   E346 : Short_Integer; pragma Import (Ada, E346, "prj__nmsc_E");
   E326 : Short_Integer; pragma Import (Ada, E326, "prj__pars_E");
   E330 : Short_Integer; pragma Import (Ada, E330, "prj__part_E");
   E342 : Short_Integer; pragma Import (Ada, E342, "prj__pp_E");
   E344 : Short_Integer; pragma Import (Ada, E344, "prj__proc_E");
   E328 : Short_Integer; pragma Import (Ada, E328, "prj__conf_E");
   E340 : Short_Integer; pragma Import (Ada, E340, "prj__strt_E");
   E292 : Short_Integer; pragma Import (Ada, E292, "prj__util_E");
   E215 : Short_Integer; pragma Import (Ada, E215, "sinfo_E");
   E205 : Short_Integer; pragma Import (Ada, E205, "atree_E");
   E296 : Short_Integer; pragma Import (Ada, E296, "sinput__p_E");
   E350 : Short_Integer; pragma Import (Ada, E350, "switch__m_E");
   E308 : Short_Integer; pragma Import (Ada, E308, "usage_E");
   E194 : Short_Integer; pragma Import (Ada, E194, "widechar_E");
   E264 : Short_Integer; pragma Import (Ada, E264, "errutil_E");
   E310 : Short_Integer; pragma Import (Ada, E310, "mlib_E");
   E316 : Short_Integer; pragma Import (Ada, E316, "mlib__fil_E");
   E322 : Short_Integer; pragma Import (Ada, E322, "mlib__prj_E");
   E318 : Short_Integer; pragma Import (Ada, E318, "mlib__tgt_E");
   E320 : Short_Integer; pragma Import (Ada, E320, "mlib__tgt__specific_E");
   E314 : Short_Integer; pragma Import (Ada, E314, "mlib__utl_E");
   E288 : Short_Integer; pragma Import (Ada, E288, "prj__err_E");

   Local_Priority_Specific_Dispatching : constant String := "";
   Local_Interrupt_States : constant String := "";

   Is_Elaborated : Boolean := False;

   procedure finalize_library is
   begin
      E282 := E282 - 1;
      E279 := E279 - 1;
      declare
         procedure F1;
         pragma Import (Ada, F1, "makeutl__finalize_spec");
      begin
         F1;
      end;
      declare
         procedure F2;
         pragma Import (Ada, F2, "prj__finalize_spec");
      begin
         F2;
      end;
      E304 := E304 - 1;
      declare
         procedure F3;
         pragma Import (Ada, F3, "ada__text_io__finalize_spec");
      begin
         F3;
      end;
      E056 := E056 - 1;
      E157 := E157 - 1;
      declare
         procedure F4;
         pragma Import (Ada, F4, "system__regexp__finalize_spec");
      begin
         F4;
      end;
      declare
         procedure F5;
         pragma Import (Ada, F5, "ada__directories__finalize_spec");
      begin
         F5;
      end;
      E104 := E104 - 1;
      declare
         procedure F6;
         pragma Import (Ada, F6, "ada__strings__unbounded__finalize_spec");
      begin
         F6;
      end;
      E118 := E118 - 1;
      E114 := E114 - 1;
      declare
         procedure F7;
         pragma Import (Ada, F7, "system__file_io__finalize_body");
      begin
         E142 := E142 - 1;
         F7;
      end;
      declare
         procedure F8;
         pragma Import (Ada, F8, "system__file_control_block__finalize_spec");
      begin
         E151 := E151 - 1;
         F8;
      end;
      E153 := E153 - 1;
      declare
         procedure F9;
         pragma Import (Ada, F9, "system__pool_global__finalize_spec");
      begin
         F9;
      end;
      declare
         procedure F10;
         pragma Import (Ada, F10, "system__storage_pools__subpools__finalize_spec");
      begin
         F10;
      end;
      declare
         procedure F11;
         pragma Import (Ada, F11, "system__finalization_masters__finalize_spec");
      begin
         F11;
      end;
      declare
         procedure Reraise_Library_Exception_If_Any;
            pragma Import (Ada, Reraise_Library_Exception_If_Any, "__gnat_reraise_library_exception_if_any");
      begin
         Reraise_Library_Exception_If_Any;
      end;
   end finalize_library;

   procedure adafinal is
      procedure s_stalib_adafinal;
      pragma Import (C, s_stalib_adafinal, "system__standard_library__adafinal");
   begin
      if not Is_Elaborated then
         return;
      end if;
      Is_Elaborated := False;
      s_stalib_adafinal;
   end adafinal;

   type No_Param_Proc is access procedure;

   procedure adainit is
      Main_Priority : Integer;
      pragma Import (C, Main_Priority, "__gl_main_priority");
      Time_Slice_Value : Integer;
      pragma Import (C, Time_Slice_Value, "__gl_time_slice_val");
      WC_Encoding : Character;
      pragma Import (C, WC_Encoding, "__gl_wc_encoding");
      Locking_Policy : Character;
      pragma Import (C, Locking_Policy, "__gl_locking_policy");
      Queuing_Policy : Character;
      pragma Import (C, Queuing_Policy, "__gl_queuing_policy");
      Task_Dispatching_Policy : Character;
      pragma Import (C, Task_Dispatching_Policy, "__gl_task_dispatching_policy");
      Priority_Specific_Dispatching : System.Address;
      pragma Import (C, Priority_Specific_Dispatching, "__gl_priority_specific_dispatching");
      Num_Specific_Dispatching : Integer;
      pragma Import (C, Num_Specific_Dispatching, "__gl_num_specific_dispatching");
      Main_CPU : Integer;
      pragma Import (C, Main_CPU, "__gl_main_cpu");
      Interrupt_States : System.Address;
      pragma Import (C, Interrupt_States, "__gl_interrupt_states");
      Num_Interrupt_States : Integer;
      pragma Import (C, Num_Interrupt_States, "__gl_num_interrupt_states");
      Unreserve_All_Interrupts : Integer;
      pragma Import (C, Unreserve_All_Interrupts, "__gl_unreserve_all_interrupts");
      Detect_Blocking : Integer;
      pragma Import (C, Detect_Blocking, "__gl_detect_blocking");
      Default_Stack_Size : Integer;
      pragma Import (C, Default_Stack_Size, "__gl_default_stack_size");
      Leap_Seconds_Support : Integer;
      pragma Import (C, Leap_Seconds_Support, "__gl_leap_seconds_support");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");

      Finalize_Library_Objects : No_Param_Proc;
      pragma Import (C, Finalize_Library_Objects, "__gnat_finalize_library_objects");
   begin
      if Is_Elaborated then
         return;
      end if;
      Is_Elaborated := True;
      Main_Priority := -1;
      Time_Slice_Value := -1;
      WC_Encoding := 'b';
      Locking_Policy := ' ';
      Queuing_Policy := ' ';
      Task_Dispatching_Policy := ' ';
      Priority_Specific_Dispatching :=
        Local_Priority_Specific_Dispatching'Address;
      Num_Specific_Dispatching := 0;
      Main_CPU := -1;
      Interrupt_States := Local_Interrupt_States'Address;
      Num_Interrupt_States := 0;
      Unreserve_All_Interrupts := 0;
      Detect_Blocking := 0;
      Default_Stack_Size := -1;
      Leap_Seconds_Support := 0;

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      Finalize_Library_Objects := finalize_library'access;

      Gnat.Spelling_Checker'Elab_Body;
      E334 := E334 + 1;
      System.Soft_Links'Elab_Spec;
      E227 := E227 + 1;
      E275 := E275 + 1;
      System.Exception_Table'Elab_Body;
      E020 := E020 + 1;
      Ada.Containers'Elab_Spec;
      E053 := E053 + 1;
      Ada.Io_Exceptions'Elab_Spec;
      E127 := E127 + 1;
      Ada.Strings'Elab_Spec;
      E091 := E091 + 1;
      Ada.Strings.Maps'Elab_Spec;
      Ada.Strings.Maps.Constants'Elab_Spec;
      E096 := E096 + 1;
      Ada.Tags'Elab_Spec;
      Ada.Streams'Elab_Spec;
      E126 := E126 + 1;
      Interfaces.C'Elab_Spec;
      Interfaces.C.Strings'Elab_Spec;
      System.Exceptions'Elab_Spec;
      E026 := E026 + 1;
      System.Finalization_Root'Elab_Spec;
      E129 := E129 + 1;
      Ada.Finalization'Elab_Spec;
      E124 := E124 + 1;
      System.Storage_Pools'Elab_Spec;
      E131 := E131 + 1;
      System.Finalization_Masters'Elab_Spec;
      System.Storage_Pools.Subpools'Elab_Spec;
      Ada.Calendar'Elab_Spec;
      Ada.Calendar'Elab_Body;
      E058 := E058 + 1;
      Ada.Calendar.Time_Zones'Elab_Spec;
      E070 := E070 + 1;
      Gnat.Directory_Operations'Elab_Spec;
      System.Assertions'Elab_Spec;
      E165 := E165 + 1;
      System.Pool_Global'Elab_Spec;
      E153 := E153 + 1;
      System.File_Control_Block'Elab_Spec;
      E151 := E151 + 1;
      System.File_Io'Elab_Body;
      E142 := E142 + 1;
      E114 := E114 + 1;
      System.Finalization_Masters'Elab_Body;
      E118 := E118 + 1;
      E312 := E312 + 1;
      E060 := E060 + 1;
      Ada.Tags'Elab_Body;
      E106 := E106 + 1;
      E093 := E093 + 1;
      System.Soft_Links'Elab_Body;
      E014 := E014 + 1;
      System.Os_Lib'Elab_Body;
      E148 := E148 + 1;
      System.Secondary_Stack'Elab_Body;
      E008 := E008 + 1;
      Gnat.Directory_Operations'Elab_Body;
      E272 := E272 + 1;
      Ada.Strings.Unbounded'Elab_Spec;
      E104 := E104 + 1;
      Ada.Directories'Elab_Spec;
      System.Regexp'Elab_Spec;
      E157 := E157 + 1;
      Ada.Directories'Elab_Body;
      E056 := E056 + 1;
      Ada.Text_Io'Elab_Spec;
      Ada.Text_Io'Elab_Body;
      E304 := E304 + 1;
      Types'Elab_Spec;
      E170 := E170 + 1;
      E006 := E006 + 1;
      Hostparm'Elab_Spec;
      E166 := E166 + 1;
      E002 := E002 + 1;
      Opt'Elab_Spec;
      Csets'Elab_Body;
      E174 := E174 + 1;
      Output'Elab_Spec;
      E163 := E163 + 1;
      Rident'Elab_Spec;
      E197 := E197 + 1;
      Sfn_Scan'Elab_Spec;
      E268 := E268 + 1;
      E248 := E248 + 1;
      Tree_Io'Elab_Spec;
      E178 := E178 + 1;
      E221 := E221 + 1;
      E176 := E176 + 1;
      Elists'Elab_Body;
      E211 := E211 + 1;
      Erroutc'Elab_Spec;
      Namet'Elab_Spec;
      ALI'ELAB_SPEC;
      ALI.UTIL'ELAB_SPEC;
      E231 := E231 + 1;
      Fname'Elab_Body;
      E199 := E199 + 1;
      Lib'Elab_Spec;
      Osint'Elab_Spec;
      E266 := E266 + 1;
      Fmap'Elab_Body;
      E185 := E185 + 1;
      ALI'ELAB_BODY;
      E159 := E159 + 1;
      E306 := E306 + 1;
      E196 := E196 + 1;
      Sem_Aux'Elab_Spec;
      Sinput'Elab_Spec;
      E262 := E262 + 1;
      Snames'Elab_Body;
      E223 := E223 + 1;
      Aspects'Elab_Spec;
      Stringt'Elab_Body;
      E240 := E240 + 1;
      Targparm'Elab_Spec;
      Targparm'Elab_Body;
      E172 := E172 + 1;
      Osint'Elab_Body;
      E182 := E182 + 1;
      E161 := E161 + 1;
      Tempdir'Elab_Body;
      E298 := E298 + 1;
      Uintp'Elab_Spec;
      Uintp'Elab_Body;
      E217 := E217 + 1;
      Err_Vars'Elab_Spec;
      E232 := E232 + 1;
      Errout'Elab_Spec;
      Restrict'Elab_Spec;
      Urealp'Elab_Body;
      E219 := E219 + 1;
      Scans'Elab_Spec;
      E229 := E229 + 1;
      Prj'Elab_Spec;
      Prj.Attr'Elab_Spec;
      E338 := E338 + 1;
      Prj.Env'Elab_Spec;
      Prj.Ext'Elab_Spec;
      E290 := E290 + 1;
      Prj.Tree'Elab_Spec;
      Makeutl'Elab_Spec;
      Prj.Pp'Elab_Body;
      E342 := E342 + 1;
      Prj.Conf'Elab_Spec;
      Atree'Elab_Spec;
      Atree'Elab_Body;
      E205 := E205 + 1;
      E215 := E215 + 1;
      Einfo'Elab_Body;
      E209 := E209 + 1;
      E244 := E244 + 1;
      Restrict'Elab_Body;
      E234 := E234 + 1;
      Errout'Elab_Body;
      E236 := E236 + 1;
      Aspects'Elab_Body;
      E207 := E207 + 1;
      E246 := E246 + 1;
      E238 := E238 + 1;
      E260 := E260 + 1;
      Nlists'Elab_Body;
      E213 := E213 + 1;
      Switch.M'Elab_Body;
      E350 := E350 + 1;
      E308 := E308 + 1;
      E277 := E277 + 1;
      E194 := E194 + 1;
      E225 := E225 + 1;
      E242 := E242 + 1;
      Fname.Uf'Elab_Body;
      E250 := E250 + 1;
      Namet'Elab_Body;
      E192 := E192 + 1;
      Osint.M'Elab_Body;
      E324 := E324 + 1;
      E254 := E254 + 1;
      E201 := E201 + 1;
      ALI.UTIL'ELAB_BODY;
      E203 := E203 + 1;
      Errutil'Elab_Spec;
      E264 := E264 + 1;
      E316 := E316 + 1;
      Mlib.Tgt.Specific'Elab_Body;
      E320 := E320 + 1;
      E314 := E314 + 1;
      E318 := E318 + 1;
      Mlib.Prj'Elab_Body;
      E322 := E322 + 1;
      Mlib'Elab_Body;
      E310 := E310 + 1;
      Prj.Util'Elab_Body;
      E292 := E292 + 1;
      Prj.Env'Elab_Body;
      E302 := E302 + 1;
      Prj.Attr'Elab_Body;
      E284 := E284 + 1;
      Make'Elab_Body;
      E050 := E050 + 1;
      Prj.Err'Elab_Spec;
      E288 := E288 + 1;
      E296 := E296 + 1;
      Prj.Strt'Elab_Body;
      E340 := E340 + 1;
      Prj.Conf'Elab_Body;
      E328 := E328 + 1;
      Prj.Proc'Elab_Body;
      E344 := E344 + 1;
      Prj.Part'Elab_Body;
      E330 := E330 + 1;
      E326 := E326 + 1;
      Prj.Nmsc'Elab_Body;
      E346 := E346 + 1;
      E332 := E332 + 1;
      Makeutl'Elab_Body;
      E279 := E279 + 1;
      Prj.Tree'Elab_Body;
      E300 := E300 + 1;
      Prj'Elab_Body;
      E282 := E282 + 1;
   end adainit;

   procedure Ada_Main_Program;
   pragma Import (Ada, Ada_Main_Program, "_ada_gnatmake");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure Initialize (Addr : System.Address);
      pragma Import (C, Initialize, "__gnat_initialize");

      procedure Finalize;
      pragma Import (C, Finalize, "__gnat_finalize");
      SEH : aliased array (1 .. 2) of Integer;

      Ensure_Reference : aliased System.Address := Ada_Main_Program_Name'Address;
      pragma Volatile (Ensure_Reference);

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize (SEH'Address);
      adainit;
      Ada_Main_Program;
      adafinal;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ../rts/ada.o
   --   ../rts/a-charac.o
   --   ../rts/a-chlat1.o
   --   ../rts/gnat.o
   --   ../rts/g-spchge.o
   --   ../rts/g-speche.o
   --   ../rts/interfac.o
   --   ../rts/system.o
   --   ../rts/s-addope.o
   --   ../rts/s-atocou.o
   --   ../rts/s-casuti.o
   --   ../rts/g-casuti.o
   --   ../rts/s-exnllf.o
   --   ../rts/s-flocon.o
   --   ../rts/g-htable.o
   --   ../rts/s-imgboo.o
   --   ../rts/s-imenne.o
   --   ../rts/s-imgint.o
   --   ../rts/s-io.o
   --   ../rts/s-parame.o
   --   ../rts/s-crtl.o
   --   ../rts/i-cstrea.o
   --   ../rts/s-powtab.o
   --   ../rts/s-excdeb.o
   --   ../rts/s-stoele.o
   --   ../rts/s-stache.o
   --   ../rts/s-strhas.o
   --   ../rts/s-htable.o
   --   ../rts/s-string.o
   --   ../rts/g-string.o
   --   ../rts/g-os_lib.o
   --   ../rts/s-traent.o
   --   ../rts/s-tasloc.o
   --   ../rts/s-unstyp.o
   --   ../rts/s-utf_32.o
   --   ../rts/s-valuti.o
   --   ../rts/s-valuns.o
   --   ../rts/s-valrea.o
   --   ../rts/s-valllu.o
   --   ../rts/s-valint.o
   --   ../rts/s-valenu.o
   --   ../rts/s-valboo.o
   --   ../rts/s-wchcon.o
   --   ../rts/s-wchjis.o
   --   ../rts/s-wchcnv.o
   --   ../rts/s-wchstw.o
   --   ../rts/a-elchha.o
   --   ../rts/g-byorma.o
   --   ../rts/g-dynhta.o
   --   ../rts/s-bitops.o
   --   ../rts/s-carun8.o
   --   ../rts/s-conca2.o
   --   ../rts/s-crc32.o
   --   ../rts/s-exctab.o
   --   ../rts/a-contai.o
   --   ../rts/a-crbltr.o
   --   ../rts/a-ioexce.o
   --   ../rts/a-string.o
   --   ../rts/a-stmaco.o
   --   ../rts/a-strsea.o
   --   ../rts/a-stream.o
   --   ../rts/s-multip.o
   --   ../rts/s-except.o
   --   ../rts/s-excmac.o
   --   ../rts/s-finroo.o
   --   ../rts/a-finali.o
   --   ../rts/s-oscons.o
   --   ../rts/s-stopoo.o
   --   ../rts/s-spsufi.o
   --   ../rts/s-stratt.o
   --   ../rts/s-win32.o
   --   ../rts/s-winext.o
   --   ../rts/s-osprim.o
   --   ../rts/a-calend.o
   --   ../rts/a-catizo.o
   --   ../rts/s-assert.o
   --   ../rts/s-filatt.o
   --   ../rts/s-memory.o
   --   ../rts/s-stalib.o
   --   ../rts/s-pooglo.o
   --   ../rts/s-ficobl.o
   --   ../rts/s-fileio.o
   --   ../rts/s-stposu.o
   --   ../rts/s-finmas.o
   --   ../rts/i-cstrin.o
   --   ../rts/i-c.o
   --   ../rts/a-tags.o
   --   ../rts/a-strfix.o
   --   ../rts/a-strmap.o
   --   ../rts/s-soflin.o
   --   ../rts/s-os_lib.o
   --   ../rts/a-comlin.o
   --   ../rts/a-chahan.o
   --   ../rts/s-secsta.o
   --   ../rts/g-dirope.o
   --   ../rts/a-calfor.o
   --   ../rts/s-addima.o
   --   ../rts/a-strunb.o
   --   ../rts/a-dirval.o
   --   ../rts/s-regexp.o
   --   ../rts/a-direct.o
   --   ../rts/g-regexp.o
   --   ../rts/a-except.o
   --   ../rts/s-traceb.o
   --   ../rts/a-textio.o
   --   ./debug.o
   --   ./types.o
   --   ./alloc.o
   --   ./gnatvsn.o
   --   ./hostparm.o
   --   ./krunch.o
   --   ./gnatmake.o
   --   ./csets.o
   --   ./output.o
   --   ./rident.o
   --   ./sfn_scan.o
   --   ./stylesw.o
   --   ./tree_io.o
   --   ./stand.o
   --   ./opt.o
   --   ./table.o
   --   ./elists.o
   --   ./binderr.o
   --   ./fname.o
   --   ./fname-sf.o
   --   ./fmap.o
   --   ./ali.o
   --   ./switch.o
   --   ./sdefault.o
   --   ./sinput-c.o
   --   ./snames.o
   --   ./stringt.o
   --   ./targparm.o
   --   ./osint.o
   --   ./butil.o
   --   ./tempdir.o
   --   ./uintp.o
   --   ./err_vars.o
   --   ./urealp.o
   --   ./scans.o
   --   ./prj-attr-pm.o
   --   ./prj-ext.o
   --   ./prj-pp.o
   --   ./atree.o
   --   ./sinfo.o
   --   ./einfo.o
   --   ./uname.o
   --   ./restrict.o
   --   ./errout.o
   --   ./aspects.o
   --   ./sem_aux.o
   --   ./erroutc.o
   --   ./styleg.o
   --   ./nlists.o
   --   ./switch-m.o
   --   ./usage.o
   --   ./makeusg.o
   --   ./widechar.o
   --   ./sinput.o
   --   ./lib.o
   --   ./fname-uf.o
   --   ./namet.o
   --   ./osint-m.o
   --   ./scng.o
   --   ./casing.o
   --   ./ali-util.o
   --   ./errutil.o
   --   ./mlib-fil.o
   --   ./mlib-tgt-specific.o
   --   ./mlib-utl.o
   --   ./prj-com.o
   --   ./mlib-tgt.o
   --   ./mlib-prj.o
   --   ./mlib.o
   --   ./prj-util.o
   --   ./prj-env.o
   --   ./prj-attr.o
   --   ./make.o
   --   ./prj-err.o
   --   ./sinput-p.o
   --   ./prj-strt.o
   --   ./prj-conf.o
   --   ./prj-proc.o
   --   ./prj-part.o
   --   ./prj-pars.o
   --   ./prj-nmsc.o
   --   ./prj-dect.o
   --   ./makeutl.o
   --   ./prj-tree.o
   --   ./prj.o
   --   -L../rts/
   --   -L./
   --   -L/cygdrive/i/szsz/tmpp/gcc/gcc-4.9.3-1.x86_64/src/gcc-4.9.3/gcc/ada/
   --   -L/usr/lib/gcc/x86_64-pc-cygwin/4.9.3/adalib/
   --   -static
   --   -lgnat
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
