/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.28 from the
 * contents of GMainLoop.xs. Do not edit this file, edit GMainLoop.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "GMainLoop.xs"
/*
 * Copyright (C) 2003-2005 by the gtk2-perl team (see the file AUTHORS for
 * the full list)
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * $Id$
 */

#include "gperl.h"

/* stuff from gmain.h, the main loop and friends */
/*

GMainLoop is in libglib; GClosure is in libgobject.  the mainloop can't refer
to GClosure for dependency reasons, but the code is designed to be used with
GClosure anyway.  that's what we'll do here.

specifically, GSourceDummyMarshal is just a placeholder for GClosureMarshal.

since we have GClosure implemented in GClosure.xs, we'll use it to handle
the callbacks here.


in the more general sense, this file offers the GLib-level interface to the
main loop stuff wrapped by the Gtk2 module.  at the current point, i can't
think of any reason to expose the lower-level main loop stuff here, because
how many apps are going to be using the event loop without Gtk?  then again,
it's quite conceivable that you'd want to do that, so it's not precluded
(just not done).

if you want to implement the main loop stuff here, you'll need to create
typemaps for these types:

	GMainContext	<- Opaque
	GMainLoop	<- Opaque

and you'll need to typemap these if you want to create custom sources
from perl:

	GSource
	GSourceCallbackFuncs
	GSourceFuncs

as far as i can tell, each of these is a ref-counted object, but none
are GObject or GBoxed descendents (as they are part of glib, not gobject!).


for anyone who needs to implement this stuff, i've left the majority
of gmain.h in here, commented out.

*/


/*
 * Since 5.7.3, perl uses "safe" signal handling by default.
 * (As gtk2-perl requires at least 5.8.0, this is relevant to us.)
 * To protect the interpreter from having signal handlers run during
 * important and otherwise uninterruptible operations, when something
 * is installed in %SIG, perl installs a sigaction handler that simply
 * sets a flag saying that a signal is pending; then, at "strategic"
 * points in later operation, it checks that flag.  This is done using
 * the PERL_ASYNC_CHECK() macro after each op.
 *
 * This is important, because while a glib main loop is running, it generally
 * sleeps in a poll(), and control does not normally return to perl.  That
 * causes pending signals to pile up, and looks to the user as though the
 * signals are being ignored.
 *
 * To solve this, the bindings will always install an event source which
 * watches PL_sig_pending, and calls the PERL_ASYNC_CHECK() macro whenever
 * we see it go true.  Since an async signal will wake up a poll(), this
 * will always run at just the right time, so no delays or other performance
 * penalties result.
 *
 * Thanks to Jan Hudec for the implementation idea:
 * http://mail.gnome.org/archives/gtk-perl-list/2004-December/msg00034.html
 */

static gboolean
async_watcher_prepare (GSource * source,
		       gint * timeout)
{
	PERL_UNUSED_VAR (source);
	/* wait as long as you like.  we rely on the fact that the
	 * poll will be awoken by the receipt of an async signal. */
	*timeout = -1;
	return FALSE;
}
static gboolean
async_watcher_check (GSource * source)
{
	PERL_UNUSED_VAR (source);
	return PL_sig_pending;
}
static gboolean
async_watcher_dispatch (GSource     * source,
                        GSourceFunc   callback,
                        gpointer      user_data)
{
	PERL_UNUSED_VAR (source);
	PERL_UNUSED_VAR (callback);
	PERL_UNUSED_VAR (user_data);
	/* this checks PL_sig_pending again, but that's probably not
	 * a bad thing -- it's conceivable that since the check, some
	 * other handler has triggered a perl callback, which would've
	 * cause perl to dispatch the signal handlers, and if we didn't
	 * recheck here we'd redispatch. */
	PERL_ASYNC_CHECK ();
	return TRUE;
}
static void
async_watcher_install (void)
{
	static GSourceFuncs async_watcher_funcs = {
		async_watcher_prepare,
		async_watcher_check,
		async_watcher_dispatch,
		NULL
	};
	/* FIXME: we never unref the watcher. */
	GSource * async_watcher =
		g_source_new (&async_watcher_funcs, sizeof (GSource));
	g_source_attach (async_watcher, NULL);
}

#if GLIB_CHECK_VERSION (2, 4, 0)

static void
gperl_child_watch_callback (GPid pid, gint status, gpointer cb)
{
	gperl_callback_invoke ((GPerlCallback*)cb, NULL, (int) pid, status);
}

#endif /* 2.4 */

#line 159 "GMainLoop.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 303 "GMainLoop.c"
#if GLIB_CHECK_VERSION(2,4,0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Glib_main_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib_main_depth)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;

	RETVAL = g_main_depth();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__MainContext_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GMainContext *	RETVAL;

	RETVAL = g_main_context_new(/*void*/);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "Glib::MainContext", RETVAL);
	    g_main_context_ref (RETVAL);
	    ST(0) = RETVALSV;
	}
#line 220 "GMainLoop.xs"
	g_main_context_unref (RETVAL); /* release the typemap's ref, so the 
	                                  wrapper owns the object */
#line 346 "GMainLoop.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__MainContext_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "maincontext");
    {
	GMainContext *	maincontext;

	if (!gperl_sv_is_ref (ST(0))) {
		maincontext = NULL;
	} else {
		maincontext = INT2PTR (GMainContext *, SvIV (SvRV (ST(0))));
	}
;
#line 227 "GMainLoop.xs"
	g_main_context_unref (maincontext);
#line 369 "GMainLoop.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__MainContext_default); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_default)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GMainContext *	RETVAL;

	RETVAL = g_main_context_default(/*void*/);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "Glib::MainContext", RETVAL);
	    g_main_context_ref (RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__MainContext_iteration); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_iteration)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "context, may_block");
    {
	gboolean	RETVAL;
	GMainContext *	context;
	gboolean	may_block = (bool)SvTRUE(ST(1))
;

	if (!gperl_sv_is_ref (ST(0))) {
		context = NULL;
	} else {
		context = INT2PTR (GMainContext *, SvIV (SvRV (ST(0))));
	}
;

	RETVAL = g_main_context_iteration(context, may_block);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__MainContext_pending); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_pending)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "context");
    {
	gboolean	RETVAL;
	GMainContext *	context;

	if (!gperl_sv_is_ref (ST(0))) {
		context = NULL;
	} else {
		context = INT2PTR (GMainContext *, SvIV (SvRV (ST(0))));
	}
;

	RETVAL = g_main_context_pending(context);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 12, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Glib__MainContext_is_owner); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainContext_is_owner)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "context");
    {
	gboolean	RETVAL;
	GMainContext *	context;

	if (!gperl_sv_is_ref (ST(0))) {
		context = NULL;
	} else {
		context = INT2PTR (GMainContext *, SvIV (SvRV (ST(0))));
	}
;

	RETVAL = g_main_context_is_owner(context);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__MainLoop_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "class, context=NULL, is_running=FALSE");
    {
	GMainContext *	context;
	gboolean	is_running;
	GMainLoop *	RETVAL;

	if (items < 2)
	    context = NULL;
	else {
	    if (!gperl_sv_is_ref (ST(1))) {
		    context = NULL;
	    } else {
		    context = INT2PTR (GMainContext *, SvIV (SvRV (ST(1))));
	    }
;
	}

	if (items < 3)
	    is_running = FALSE;
	else {
	    is_running = (bool)SvTRUE(ST(2))
;
	}

	RETVAL = g_main_loop_new(context, is_running);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "Glib::MainLoop", RETVAL);
	    g_main_loop_ref (RETVAL);
	    ST(0) = RETVALSV;
	}
#line 311 "GMainLoop.xs"
	g_main_loop_unref (RETVAL);
#line 514 "GMainLoop.c"
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__MainLoop_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "mainloop");
    {
	GMainLoop *	mainloop = INT2PTR (GMainLoop *, SvIV (SvRV (ST(0))))
;
#line 317 "GMainLoop.xs"
	g_main_loop_unref (mainloop);
#line 531 "GMainLoop.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__MainLoop_run); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_run)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "loop");
    {
	GMainLoop *	loop = INT2PTR (GMainLoop *, SvIV (SvRV (ST(0))))
;

	g_main_loop_run(loop);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__MainLoop_quit); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_quit)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "loop");
    {
	GMainLoop *	loop = INT2PTR (GMainLoop *, SvIV (SvRV (ST(0))))
;

	g_main_loop_quit(loop);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Glib__MainLoop_is_running); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_is_running)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "loop");
    {
	gboolean	RETVAL;
	GMainLoop *	loop = INT2PTR (GMainLoop *, SvIV (SvRV (ST(0))))
;

	RETVAL = g_main_loop_is_running(loop);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__MainLoop_get_context); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__MainLoop_get_context)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "loop");
    {
	GMainContext *	RETVAL;
	GMainLoop *	loop = INT2PTR (GMainLoop *, SvIV (SvRV (ST(0))))
;

	RETVAL = g_main_loop_get_context(loop);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv (RETVALSV, "Glib::MainContext", RETVAL);
	    g_main_context_ref (RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Source_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Source_remove)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "class, tag");
    {
	guint	tag = (guint)SvUV(ST(1))
;
	gboolean	RETVAL;

	RETVAL = g_source_remove(tag);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__Timeout_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Timeout_add)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "class, interval, callback, data=NULL, priority=G_PRIORITY_DEFAULT");
    {
	guint	interval = (guint)SvUV(ST(1))
;
	SV *	callback = ST(2)
;
	SV *	data;
	gint	priority;
#line 447 "GMainLoop.xs"
	GClosure * closure;
	GSource * source;
#line 645 "GMainLoop.c"
	guint	RETVAL;
	dXSTARG;

	if (items < 4)
	    data = NULL;
	else {
	    data = ST(3)
;
	}

	if (items < 5)
	    priority = G_PRIORITY_DEFAULT;
	else {
	    priority = (gint)SvIV(ST(4))
;
	}
#line 450 "GMainLoop.xs"
	closure = gperl_closure_new (callback, data, FALSE);
	source = g_timeout_source_new (interval);
	if (priority != G_PRIORITY_DEFAULT)
		g_source_set_priority (source, priority);
	g_source_set_closure (source, closure);
	RETVAL = g_source_attach (source, NULL);
	g_source_unref (source);
#line 670 "GMainLoop.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 14, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Glib__Timeout_add_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Timeout_add_seconds)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "class, interval, callback, data=NULL, priority=G_PRIORITY_DEFAULT");
    {
#line 465 "GMainLoop.xs"
	GClosure * closure;
	GSource * source;
#line 690 "GMainLoop.c"
	guint	RETVAL;
	dXSTARG;
	guint	interval = (guint)SvUV(ST(1))
;
	SV *	callback = ST(2)
;
	SV *	data;
	gint	priority;

	if (items < 4)
	    data = NULL;
	else {
	    data = ST(3)
;
	}

	if (items < 5)
	    priority = G_PRIORITY_DEFAULT;
	else {
	    priority = (gint)SvIV(ST(4))
;
	}
#line 468 "GMainLoop.xs"
	closure = gperl_closure_new (callback, data, FALSE);
	source = g_timeout_source_new_seconds (interval);
	if (priority != G_PRIORITY_DEFAULT)
		g_source_set_priority (source, priority);
	g_source_set_closure (source, closure);
	RETVAL = g_source_attach (source, NULL);
	g_source_unref (source);
#line 721 "GMainLoop.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Glib__Idle_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Idle_add)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "class, callback, data=NULL, priority=G_PRIORITY_DEFAULT_IDLE");
    {
	SV *	callback = ST(1)
;
	SV *	data;
	gint	priority;
#line 500 "GMainLoop.xs"
	GClosure * closure;
	GSource * source;
#line 743 "GMainLoop.c"
	guint	RETVAL;
	dXSTARG;

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}

	if (items < 4)
	    priority = G_PRIORITY_DEFAULT_IDLE;
	else {
	    priority = (gint)SvIV(ST(3))
;
	}
#line 503 "GMainLoop.xs"
	closure = gperl_closure_new (callback, data, FALSE);
	source = g_idle_source_new ();
	g_source_set_priority (source, priority);
	g_source_set_closure (source, closure);
	RETVAL = g_source_attach (source, NULL);
	g_source_unref (source);
#line 767 "GMainLoop.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Glib__IO_add_watch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__IO_add_watch)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 6)
       croak_xs_usage(cv,  "class, fd, condition, callback, data=NULL, priority=G_PRIORITY_DEFAULT");
    {
	int	fd = (int)SvIV(ST(1))
;
	GIOCondition	condition = gperl_convert_flags (G_TYPE_IO_CONDITION, ST(2))
;
	SV *	callback = ST(3)
;
	SV *	data;
	gint	priority;
#line 550 "GMainLoop.xs"
	GClosure * closure;
	GSource * source;
	GIOChannel * channel;
#line 793 "GMainLoop.c"
	guint	RETVAL;
	dXSTARG;

	if (items < 5)
	    data = NULL;
	else {
	    data = ST(4)
;
	}

	if (items < 6)
	    priority = G_PRIORITY_DEFAULT;
	else {
	    priority = (gint)SvIV(ST(5))
;
	}
#line 554 "GMainLoop.xs"
#ifdef USE_SOCKETS_AS_HANDLES
        /* native win32 doesn't have fd's, so first convert perls fd into a winsock fd */
        channel = g_io_channel_win32_new_socket ((HANDLE)win32_get_osfhandle (fd));
#else
        channel = g_io_channel_unix_new (fd);
#endif  /* USE_SOCKETS_AS_HANDLES */
	source = g_io_create_watch (channel, condition);
	if (priority != G_PRIORITY_DEFAULT)
		g_source_set_priority (source, priority);
	closure = gperl_closure_new (callback, data, FALSE);
	g_source_set_closure (source, closure);
	RETVAL = g_source_attach (source, NULL);
	g_source_unref (source);
	g_io_channel_unref (channel);
#line 825 "GMainLoop.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#if GLIB_CHECK_VERSION (2, 4, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Glib__Child_watch_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Glib__Child_watch_add)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 5)
       croak_xs_usage(cv,  "class, pid, callback, data=NULL, priority=G_PRIORITY_DEFAULT");
    {
#line 599 "GMainLoop.xs"
	GPerlCallback* cb;
	GType param_types[2];
#line 845 "GMainLoop.c"
	guint	RETVAL;
	dXSTARG;
	int	pid = (int)SvIV(ST(1))
;
	SV *	callback = ST(2)
;
	SV *	data;
	gint	priority;

	if (items < 4)
	    data = NULL;
	else {
	    data = ST(3)
;
	}

	if (items < 5)
	    priority = G_PRIORITY_DEFAULT;
	else {
	    priority = (gint)SvIV(ST(4))
;
	}
#line 602 "GMainLoop.xs"
	/* As of Glib 2.16.4 there's no "callback_closure" func in
	   g_child_watch_funcs, and none added there by
	   g_source_set_closure (unlike idle, timeout and io above),
	   so go GPerlCallback style. */
	param_types[0] = G_TYPE_INT;
	param_types[1] = G_TYPE_INT;
	cb = gperl_callback_new (callback, data, 2, param_types, 0);
	RETVAL = g_child_watch_add_full (priority, (GPid) pid,
	       	 			 gperl_child_watch_callback,
					 cb,
	       	 	(GDestroyNotify) gperl_callback_destroy);
#line 880 "GMainLoop.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}

#endif /* 2.4 */
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Glib__MainLoop); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Glib__MainLoop)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

#if XSubPPtmpAAAA
        newXS_deffile("Glib::main_depth", XS_Glib_main_depth);
#endif
        newXS_deffile("Glib::MainContext::new", XS_Glib__MainContext_new);
        newXS_deffile("Glib::MainContext::DESTROY", XS_Glib__MainContext_DESTROY);
        newXS_deffile("Glib::MainContext::default", XS_Glib__MainContext_default);
        newXS_deffile("Glib::MainContext::iteration", XS_Glib__MainContext_iteration);
        newXS_deffile("Glib::MainContext::pending", XS_Glib__MainContext_pending);
#if XSubPPtmpAAAB
        newXS_deffile("Glib::MainContext::is_owner", XS_Glib__MainContext_is_owner);
#endif
        newXS_deffile("Glib::MainLoop::new", XS_Glib__MainLoop_new);
        newXS_deffile("Glib::MainLoop::DESTROY", XS_Glib__MainLoop_DESTROY);
        newXS_deffile("Glib::MainLoop::run", XS_Glib__MainLoop_run);
        newXS_deffile("Glib::MainLoop::quit", XS_Glib__MainLoop_quit);
        newXS_deffile("Glib::MainLoop::is_running", XS_Glib__MainLoop_is_running);
        newXS_deffile("Glib::MainLoop::get_context", XS_Glib__MainLoop_get_context);
        newXS_deffile("Glib::Source::remove", XS_Glib__Source_remove);
        newXS_deffile("Glib::Timeout::add", XS_Glib__Timeout_add);
#if XSubPPtmpAAAC
        newXS_deffile("Glib::Timeout::add_seconds", XS_Glib__Timeout_add_seconds);
#endif
        newXS_deffile("Glib::Idle::add", XS_Glib__Idle_add);
        newXS_deffile("Glib::IO::add_watch", XS_Glib__IO_add_watch);
#if XSubPPtmpAAAD
        newXS_deffile("Glib::Child::watch_add", XS_Glib__Child_watch_add);
#endif

    /* Initialisation Section */

#line 152 "GMainLoop.xs"
	async_watcher_install ();

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#line 522 "GMainLoop.xs"
	gperl_register_fundamental (G_TYPE_IO_CONDITION, "Glib::IOCondition");

#if XSubPPtmpAAAD
#endif
#line 959 "GMainLoop.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

