/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLInputElement.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "FileList.h"
#include "HTMLFormElement.h"
#include "HTMLInputElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSFileList.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(DATALIST_ELEMENT)
#include "HTMLElement.h"
#include "JSHTMLElement.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLInputElementTableValues[] =
{
    { "accept", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAccept), (intptr_t)setJSHTMLInputElementAccept, NoIntrinsic },
    { "alt", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAlt), (intptr_t)setJSHTMLInputElementAlt, NoIntrinsic },
    { "autocomplete", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAutocomplete), (intptr_t)setJSHTMLInputElementAutocomplete, NoIntrinsic },
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAutofocus), (intptr_t)setJSHTMLInputElementAutofocus, NoIntrinsic },
    { "defaultChecked", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDefaultChecked), (intptr_t)setJSHTMLInputElementDefaultChecked, NoIntrinsic },
    { "checked", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementChecked), (intptr_t)setJSHTMLInputElementChecked, NoIntrinsic },
    { "dirName", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDirName), (intptr_t)setJSHTMLInputElementDirName, NoIntrinsic },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDisabled), (intptr_t)setJSHTMLInputElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementForm), (intptr_t)0, NoIntrinsic },
    { "files", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFiles), (intptr_t)setJSHTMLInputElementFiles, NoIntrinsic },
    { "formAction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormAction), (intptr_t)setJSHTMLInputElementFormAction, NoIntrinsic },
    { "formEnctype", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormEnctype), (intptr_t)setJSHTMLInputElementFormEnctype, NoIntrinsic },
    { "formMethod", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormMethod), (intptr_t)setJSHTMLInputElementFormMethod, NoIntrinsic },
    { "formNoValidate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormNoValidate), (intptr_t)setJSHTMLInputElementFormNoValidate, NoIntrinsic },
    { "formTarget", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementFormTarget), (intptr_t)setJSHTMLInputElementFormTarget, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementHeight), (intptr_t)setJSHTMLInputElementHeight, NoIntrinsic },
    { "indeterminate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementIndeterminate), (intptr_t)setJSHTMLInputElementIndeterminate, NoIntrinsic },
#if ENABLE(DATALIST_ELEMENT)
    { "list", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementList), (intptr_t)0, NoIntrinsic },
#endif
    { "max", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMax), (intptr_t)setJSHTMLInputElementMax, NoIntrinsic },
    { "maxLength", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMaxLength), (intptr_t)setJSHTMLInputElementMaxLength, NoIntrinsic },
    { "min", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMin), (intptr_t)setJSHTMLInputElementMin, NoIntrinsic },
    { "multiple", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementMultiple), (intptr_t)setJSHTMLInputElementMultiple, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementName), (intptr_t)setJSHTMLInputElementName, NoIntrinsic },
    { "pattern", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementPattern), (intptr_t)setJSHTMLInputElementPattern, NoIntrinsic },
    { "placeholder", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementPlaceholder), (intptr_t)setJSHTMLInputElementPlaceholder, NoIntrinsic },
    { "readOnly", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementReadOnly), (intptr_t)setJSHTMLInputElementReadOnly, NoIntrinsic },
    { "required", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementRequired), (intptr_t)setJSHTMLInputElementRequired, NoIntrinsic },
    { "size", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSize), (intptr_t)setJSHTMLInputElementSize, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSrc), (intptr_t)setJSHTMLInputElementSrc, NoIntrinsic },
    { "step", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementStep), (intptr_t)setJSHTMLInputElementStep, NoIntrinsic },
    { "type", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementType), (intptr_t)setJSHTMLInputElementType, NoIntrinsic },
    { "defaultValue", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementDefaultValue), (intptr_t)setJSHTMLInputElementDefaultValue, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValue), (intptr_t)setJSHTMLInputElementValue, NoIntrinsic },
    { "valueAsDate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValueAsDate), (intptr_t)setJSHTMLInputElementValueAsDate, NoIntrinsic },
    { "valueAsNumber", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValueAsNumber), (intptr_t)setJSHTMLInputElementValueAsNumber, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWidth), (intptr_t)setJSHTMLInputElementWidth, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementLabels), (intptr_t)0, NoIntrinsic },
    { "selectionStart", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionStart), (intptr_t)setJSHTMLInputElementSelectionStart, NoIntrinsic },
    { "selectionEnd", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionEnd), (intptr_t)setJSHTMLInputElementSelectionEnd, NoIntrinsic },
    { "selectionDirection", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementSelectionDirection), (intptr_t)setJSHTMLInputElementSelectionDirection, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementAlign), (intptr_t)setJSHTMLInputElementAlign, NoIntrinsic },
#if ENABLE(DIRECTORY_UPLOAD)
    { "webkitdirectory", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitdirectory), (intptr_t)setJSHTMLInputElementWebkitdirectory, NoIntrinsic },
#endif
    { "useMap", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementUseMap), (intptr_t)setJSHTMLInputElementUseMap, NoIntrinsic },
    { "incremental", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementIncremental), (intptr_t)setJSHTMLInputElementIncremental, NoIntrinsic },
#if ENABLE(INPUT_SPEECH)
    { "webkitSpeech", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitSpeech), (intptr_t)setJSHTMLInputElementWebkitSpeech, NoIntrinsic },
#endif
#if ENABLE(INPUT_SPEECH)
    { "webkitGrammar", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementWebkitGrammar), (intptr_t)setJSHTMLInputElementWebkitGrammar, NoIntrinsic },
#endif
#if ENABLE(INPUT_SPEECH)
    { "onwebkitspeechchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementOnwebkitspeechchange), (intptr_t)setJSHTMLInputElementOnwebkitspeechchange, NoIntrinsic },
#endif
#if ENABLE(MEDIA_CAPTURE)
    { "capture", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementCapture), (intptr_t)setJSHTMLInputElementCapture, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLInputElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLInputElementTable = { 138, 127, JSHTMLInputElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLInputElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLInputElementConstructorTable = { 1, 0, JSHTMLInputElementConstructorTableValues, 0 };
const ClassInfo JSHTMLInputElementConstructor::s_info = { "HTMLInputElementConstructor", &Base::s_info, &JSHTMLInputElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLInputElementConstructor) };

JSHTMLInputElementConstructor::JSHTMLInputElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLInputElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLInputElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLInputElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLInputElementConstructor, JSDOMWrapper>(exec, &JSHTMLInputElementConstructorTable, jsCast<JSHTMLInputElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLInputElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLInputElementConstructor, JSDOMWrapper>(exec, &JSHTMLInputElementConstructorTable, jsCast<JSHTMLInputElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLInputElementPrototypeTableValues[] =
{
    { "stepUp", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionStepUp), (intptr_t)1, NoIntrinsic },
    { "stepDown", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionStepDown), (intptr_t)1, NoIntrinsic },
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { "select", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSelect), (intptr_t)0, NoIntrinsic },
    { "setRangeText", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSetRangeText), (intptr_t)1, NoIntrinsic },
    { "setSelectionRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLInputElementPrototypeFunctionSetSelectionRange), (intptr_t)3, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLInputElementPrototypeTable = { 17, 15, JSHTMLInputElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLInputElementPrototype::s_info = { "HTMLInputElementPrototype", &Base::s_info, &JSHTMLInputElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLInputElementPrototype) };

JSObject* JSHTMLInputElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLInputElement>(exec, globalObject);
}

bool JSHTMLInputElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLInputElementPrototype* thisObject = jsCast<JSHTMLInputElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLInputElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLInputElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLInputElementPrototype* thisObject = jsCast<JSHTMLInputElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLInputElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLInputElement::s_info = { "HTMLInputElement", &Base::s_info, &JSHTMLInputElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLInputElement) };

JSHTMLInputElement::JSHTMLInputElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLInputElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLInputElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLInputElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLInputElementPrototype::create(exec->globalData(), globalObject, JSHTMLInputElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLInputElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLInputElement* thisObject = jsCast<JSHTMLInputElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLInputElement, Base>(exec, &JSHTMLInputElementTable, thisObject, propertyName, slot);
}

bool JSHTMLInputElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLInputElement* thisObject = jsCast<JSHTMLInputElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLInputElement, Base>(exec, &JSHTMLInputElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLInputElementAccept(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::acceptAttr));
    return result;
}


JSValue jsHTMLInputElementAlt(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::altAttr));
    return result;
}


JSValue jsHTMLInputElementAutocomplete(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::autocompleteAttr));
    return result;
}


JSValue jsHTMLInputElementAutofocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLInputElementDefaultChecked(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::checkedAttr));
    return result;
}


JSValue jsHTMLInputElementChecked(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->checked());
    return result;
}


JSValue jsHTMLInputElementDirName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::dirnameAttr));
    return result;
}


JSValue jsHTMLInputElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLInputElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLInputElementFiles(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->files()));
    return result;
}


JSValue jsHTMLInputElementFormAction(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::formactionAttr));
    return result;
}


JSValue jsHTMLInputElementFormEnctype(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->formEnctype());
    return result;
}


JSValue jsHTMLInputElementFormMethod(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->formMethod());
    return result;
}


JSValue jsHTMLInputElementFormNoValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::formnovalidateAttr));
    return result;
}


JSValue jsHTMLInputElementFormTarget(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::formtargetAttr));
    return result;
}


JSValue jsHTMLInputElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsHTMLInputElementIndeterminate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->indeterminate());
    return result;
}


#if ENABLE(DATALIST_ELEMENT)
JSValue jsHTMLInputElementList(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->list()));
    return result;
}

#endif

JSValue jsHTMLInputElementMax(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::maxAttr));
    return result;
}


JSValue jsHTMLInputElementMaxLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->maxLength());
    return result;
}


JSValue jsHTMLInputElementMin(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::minAttr));
    return result;
}


JSValue jsHTMLInputElementMultiple(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::multipleAttr));
    return result;
}


JSValue jsHTMLInputElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getNameAttribute());
    return result;
}


JSValue jsHTMLInputElementPattern(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::patternAttr));
    return result;
}


JSValue jsHTMLInputElementPlaceholder(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::placeholderAttr));
    return result;
}


JSValue jsHTMLInputElementReadOnly(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::readonlyAttr));
    return result;
}


JSValue jsHTMLInputElementRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::requiredAttr));
    return result;
}


JSValue jsHTMLInputElementSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->size());
    return result;
}


JSValue jsHTMLInputElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLInputElementStep(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::stepAttr));
    return result;
}


JSValue jsHTMLInputElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLInputElementDefaultValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->defaultValue());
    return result;
}


JSValue jsHTMLInputElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsHTMLInputElementValueAsDate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsDateOrNull(exec, impl->valueAsDate());
    return result;
}


JSValue jsHTMLInputElementValueAsNumber(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->valueAsNumber());
    return result;
}


JSValue jsHTMLInputElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsHTMLInputElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLInputElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLInputElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLInputElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLInputElementSelectionStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionStart(exec);
}


JSValue jsHTMLInputElementSelectionEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionEnd(exec);
}


JSValue jsHTMLInputElementSelectionDirection(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    return castedThis->selectionDirection(exec);
}


JSValue jsHTMLInputElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


#if ENABLE(DIRECTORY_UPLOAD)
JSValue jsHTMLInputElementWebkitdirectory(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::webkitdirectoryAttr));
    return result;
}

#endif

JSValue jsHTMLInputElementUseMap(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::usemapAttr));
    return result;
}


JSValue jsHTMLInputElementIncremental(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::incrementalAttr));
    return result;
}


#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementWebkitSpeech(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::webkitspeechAttr));
    return result;
}

#endif

#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementWebkitGrammar(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::webkitgrammarAttr));
    return result;
}

#endif

#if ENABLE(INPUT_SPEECH)
JSValue jsHTMLInputElementOnwebkitspeechchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitspeechchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(MEDIA_CAPTURE)
JSValue jsHTMLInputElementCapture(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->capture());
    return result;
}

#endif

JSValue jsHTMLInputElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLInputElement* domObject = jsCast<JSHTMLInputElement*>(asObject(slotBase));
    return JSHTMLInputElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLInputElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLInputElement* thisObject = jsCast<JSHTMLInputElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLInputElement, Base>(exec, propertyName, value, &JSHTMLInputElementTable, thisObject, slot);
}

void setJSHTMLInputElementAccept(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::acceptAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAlt(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::altAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAutocomplete(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::autocompleteAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementDefaultChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::checkedAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementChecked(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setChecked(value.toBoolean(exec));
}


void setJSHTMLInputElementDirName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::dirnameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementFiles(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setFiles(toFileList(value));
}


void setJSHTMLInputElementFormAction(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::formactionAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormEnctype(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setFormEnctype(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormMethod(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setFormMethod(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementFormNoValidate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::formnovalidateAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementFormTarget(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::formtargetAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setHeight(value.toUInt32(exec));
}


void setJSHTMLInputElementIndeterminate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setIndeterminate(value.toBoolean(exec));
}


void setJSHTMLInputElementMax(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::maxAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementMaxLength(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setMaxLength(value.toInt32(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementMin(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::minAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementMultiple(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::multipleAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementPattern(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::patternAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementPlaceholder(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::placeholderAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementReadOnly(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementRequired(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value.toBoolean(exec));
}


void setJSHTMLInputElementSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setSize(value.toUInt32(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementStep(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::stepAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementType(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setType(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementDefaultValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setDefaultValue(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setValue(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementValueAsDate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setValueAsDate(valueToDate(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementValueAsNumber(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setValueAsNumber(value.toNumber(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLInputElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setWidth(value.toUInt32(exec));
}


void setJSHTMLInputElementSelectionStart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLInputElement*>(thisObject)->setSelectionStart(exec, value);
}


void setJSHTMLInputElementSelectionEnd(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLInputElement*>(thisObject)->setSelectionEnd(exec, value);
}


void setJSHTMLInputElementSelectionDirection(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLInputElement*>(thisObject)->setSelectionDirection(exec, value);
}


void setJSHTMLInputElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


#if ENABLE(DIRECTORY_UPLOAD)
void setJSHTMLInputElementWebkitdirectory(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::webkitdirectoryAttr, value.toBoolean(exec));
}

#endif

void setJSHTMLInputElementUseMap(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::usemapAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLInputElementIncremental(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::incrementalAttr, value.toBoolean(exec));
}


#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementWebkitSpeech(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::webkitspeechAttr, value.toBoolean(exec));
}

#endif

#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementWebkitGrammar(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::webkitgrammarAttr, value.toBoolean(exec));
}

#endif

#if ENABLE(INPUT_SPEECH)
void setJSHTMLInputElementOnwebkitspeechchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setOnwebkitspeechchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(MEDIA_CAPTURE)
void setJSHTMLInputElementCapture(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(thisObject);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->setCapture(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}

#endif

JSValue JSHTMLInputElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLInputElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepUp(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        impl->stepUp(ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int n(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->stepUp(n, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionStepDown(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 0) {
        impl->stepDown(ec);
        setDOMException(exec, ec);
        return JSValue::encode(jsUndefined());
    }

    int n(exec->argument(0).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->stepDown(n, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSelect(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    impl->select();
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetRangeText1(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& replacement(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRangeText(replacement, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

static EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetRangeText2(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    HTMLInputElement* impl = static_cast<HTMLInputElement*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& replacement(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned start(exec->argument(1).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned end(exec->argument(2).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& selectionMode(argumentOrNull(exec, 3).isEmpty() ? String() : argumentOrNull(exec, 3).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setRangeText(replacement, start, end, selectionMode, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetRangeText(ExecState* exec)
{
    size_t argsCount = exec->argumentCount();
    if (argsCount == 1)
        return jsHTMLInputElementPrototypeFunctionSetRangeText1(exec);
    if (argsCount == 3 || argsCount == 4)
        return jsHTMLInputElementPrototypeFunctionSetRangeText2(exec);
    if (argsCount < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    return throwVMTypeError(exec);
}

EncodedJSValue JSC_HOST_CALL jsHTMLInputElementPrototypeFunctionSetSelectionRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLInputElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLInputElement* castedThis = jsCast<JSHTMLInputElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLInputElement::s_info);
    return JSValue::encode(castedThis->setSelectionRange(exec));
}


}
