/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMApplicationCache.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "GObjectEventListener.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMApplicationCachePrivate.h"
#include "WebKitDOMEventPrivate.h"
#include "WebKitDOMEventTarget.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_APPLICATION_CACHE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_APPLICATION_CACHE, WebKitDOMDOMApplicationCachePrivate)

typedef struct _WebKitDOMDOMApplicationCachePrivate {
    RefPtr<WebCore::DOMApplicationCache> coreObject;
} WebKitDOMDOMApplicationCachePrivate;

namespace WebKit {

WebKitDOMDOMApplicationCache* kit(WebCore::DOMApplicationCache* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_APPLICATION_CACHE(ret);

    return wrapDOMApplicationCache(obj);
}

WebCore::DOMApplicationCache* core(WebKitDOMDOMApplicationCache* request)
{
    return request ? static_cast<WebCore::DOMApplicationCache*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMApplicationCache* wrapDOMApplicationCache(WebCore::DOMApplicationCache* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_APPLICATION_CACHE(g_object_new(WEBKIT_TYPE_DOM_DOM_APPLICATION_CACHE, "core-object", coreObject, NULL));
}

} // namespace WebKit

static void webkit_dom_dom_application_cache_dispatch_event(WebKitDOMEventTarget* target, WebKitDOMEvent* event, GError** error)
{
    WebCore::Event* coreEvent = WebKit::core(event);
    WebCore::DOMApplicationCache* coreTarget = static_cast<WebCore::DOMApplicationCache*>(WEBKIT_DOM_OBJECT(target)->coreObject);

    WebCore::ExceptionCode ec = 0;
    coreTarget->dispatchEvent(coreEvent, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription description(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), description.code, description.name);
    }
}

static gboolean webkit_dom_dom_application_cache_add_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble, gpointer userData)
{
    WebCore::DOMApplicationCache* coreTarget = static_cast<WebCore::DOMApplicationCache*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::addEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble, userData);
}

static gboolean webkit_dom_dom_application_cache_remove_event_listener(WebKitDOMEventTarget* target, const char* eventName, GCallback handler, gboolean bubble)
{
    WebCore::DOMApplicationCache* coreTarget = static_cast<WebCore::DOMApplicationCache*>(WEBKIT_DOM_OBJECT(target)->coreObject);
    return WebCore::GObjectEventListener::removeEventListener(G_OBJECT(target), coreTarget, eventName, handler, bubble);
}

static void webkit_dom_event_target_init(WebKitDOMEventTargetIface* iface)
{
    iface->dispatch_event = webkit_dom_dom_application_cache_dispatch_event;
    iface->add_event_listener = webkit_dom_dom_application_cache_add_event_listener;
    iface->remove_event_listener = webkit_dom_dom_application_cache_remove_event_listener;
}

G_DEFINE_TYPE_WITH_CODE(WebKitDOMDOMApplicationCache, webkit_dom_dom_application_cache, WEBKIT_TYPE_DOM_OBJECT, G_IMPLEMENT_INTERFACE(WEBKIT_TYPE_DOM_EVENT_TARGET, webkit_dom_event_target_init))

enum {
    PROP_0,
    PROP_STATUS,
};

static void webkit_dom_dom_application_cache_finalize(GObject* object)
{
    WebKitDOMDOMApplicationCachePrivate* priv = WEBKIT_DOM_DOM_APPLICATION_CACHE_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMDOMApplicationCachePrivate();
    G_OBJECT_CLASS(webkit_dom_dom_application_cache_parent_class)->finalize(object);
}

static void webkit_dom_dom_application_cache_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMDOMApplicationCache* self = WEBKIT_DOM_DOM_APPLICATION_CACHE(object);
    WebCore::DOMApplicationCache* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_STATUS: {
        g_value_set_uint(value, coreSelf->status());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_dom_application_cache_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_application_cache_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMDOMApplicationCachePrivate* priv = WEBKIT_DOM_DOM_APPLICATION_CACHE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMApplicationCache*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_dom_application_cache_class_init(WebKitDOMDOMApplicationCacheClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMApplicationCachePrivate));
    gobjectClass->constructor = webkit_dom_dom_application_cache_constructor;
    gobjectClass->finalize = webkit_dom_dom_application_cache_finalize;
    gobjectClass->get_property = webkit_dom_dom_application_cache_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_STATUS,
                                    g_param_spec_uint("status", /* name */
                                                           "dom_application_cache_status", /* short description */
                                                           "read-only  gushort DOMApplicationCache.status", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_dom_application_cache_init(WebKitDOMDOMApplicationCache* request)
{
    WebKitDOMDOMApplicationCachePrivate* priv = WEBKIT_DOM_DOM_APPLICATION_CACHE_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMApplicationCachePrivate();
}

void
webkit_dom_dom_application_cache_update(WebKitDOMDOMApplicationCache* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_APPLICATION_CACHE(self));
    g_return_if_fail(!error || !*error);
    WebCore::DOMApplicationCache* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->update(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_application_cache_swap_cache(WebKitDOMDOMApplicationCache* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_APPLICATION_CACHE(self));
    g_return_if_fail(!error || !*error);
    WebCore::DOMApplicationCache* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->swapCache(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_dom_application_cache_abort(WebKitDOMDOMApplicationCache* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_DOM_APPLICATION_CACHE(self));
    WebCore::DOMApplicationCache* item = WebKit::core(self);
    item->abort();
}

gboolean
webkit_dom_dom_application_cache_dispatch_event(WebKitDOMDOMApplicationCache* self, WebKitDOMEvent* evt, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_APPLICATION_CACHE(self), FALSE);
    g_return_val_if_fail(WEBKIT_DOM_IS_EVENT(evt), FALSE);
    g_return_val_if_fail(!error || !*error, FALSE);
    WebCore::DOMApplicationCache* item = WebKit::core(self);
    WebCore::Event* convertedEvt = WebKit::core(evt);
    WebCore::ExceptionCode ec = 0;
    gboolean result = item->dispatchEvent(convertedEvt, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return result;
}

gushort
webkit_dom_dom_application_cache_get_status(WebKitDOMDOMApplicationCache* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_APPLICATION_CACHE(self), 0);
    WebCore::DOMApplicationCache* item = WebKit::core(self);
    gushort result = item->status();
    return result;
}

