.TH XWIN __filemansuffix__ __vendorversion__


.SH NAME
XWinrc\- XWin Server Resource Configuration File.


.SH DESCRIPTION
The X Server for the X Window System on the Cygwin/X environment
running on Microsoft Windows, \fIXWin\fP can be optionally configured
with the \fIXWinrc\fP file.  A system-wide configuration file should
be placed in \fI
__sysconfdir__/X11/system.XWinrc\fP, a per-user file
should be put at \fI$HOME/.XWinrc\fP.  The \fIsystem.XWinrc\fP file is
read only if no \fI$HOME/.XWinrc\fP exist.
.PP
With the \fI.XWinrc\fP configuration file it is possible to do the
following:
.PP
1- To include items into the menu associated with the \fIXWin\fP icon
which is in the \fIWindows\fP system tray.  This feature functions in
all XWin modes that have such tray icon.
.PP
2- To include items into the menu which is associated with the
\fIWindows\fP window that \fIXWin -multiwindow\fP produces for each
top-level X-window.  That can be done both for the generic case and
for particular programs.
.PP
3- To change the icon that is associated to the \fIWindows\fP window
that \fIXWin -multiwindow\fP produces for each top-level X-window.
Again, that can be done both for the generic case and for particular
programs.  The new icons associated should be \fIWindows\fP format
icons \fI.ico\fP.
.PP
4- To change the style that is associated to the \fIWindows\fP window
that \fI-multiwindow\fP produces for  each  top-level  X window.   Again,
that can be done both for the generic case and for particular programs.


.SH FILE FORMAT
.B Keywords
are case insensitive, but in this document they will be written
completely capitalized.
.PP
.B Comments
are legal pretty much anywhere you can have an end-of-line; they
begin with "#" or "//" and go to the end-of-line.
.PP
Quote marks in strings are optional unless the string has included spaces,
or could be parsed, ambiguously, as a misplaced keyword.
.PP
There are four kinds of instructions: miscellaneous, menu, icon and style.


.SH Miscellaneous instruction
.TP 8
.B DPI \fIresolution\fP
Sets the resolution for all screens, in dots per inch.  To be used when
the server cannot determine the screen size(s) from the hardware.

.TP 8
.B XKBLayout \fIlayout\fP
.TP 8
.B XKBModel \fImodel\fP
.TP 8
.B XKBOptions \fIoption\fP
.TP 8
.B XKBRules \fIrule\fP
.TP 8
.B XKBVariant \fIvariant\fp
These options configure the xkeyboard extension to load a particular
keyboard map as the X server starts.  The behavior is similar to the
\fIsetxkbmap\fP(1) program.

See the \fIxkeyboard-config\fP(__miscmansuffix__) manual page for a list of
keyboard configurations.

Alternatively, you can use \fIsetxkbmap\fP(1) program after \fIXWin\fP
is running.

The default is to select a keyboard configuration matching your current
layout as reported by \fIWindows\fP, if known, or the default X server
configuration if no matching keyboard configuration was found.

.TP 8
.B DEBUG \fIString\fP
The \fIString\fP is printed to the XWin log file.

.TP 8
.B TRAYICON \fIicon-specifier\fB
The \fBTRAYICON\fP keyword changes the icon \fIXWin\fP displays in the
system tray area.

.TP 8
.B SILENTEXIT
The \fBSILENTEXIT\fP keyword, which takes no parameters, disables the
exit confirmation dialog if no clients are connected.

.TP 8
.B FORCEEXIT
The \fBFORCEEXIT\fP keyword, which takes no parameters, disables the
exit confirmation dialog always.  Unsaved client work may be lost but
this may be useful if you want no dialogs.

.SH Menu instructions
.TP 8
.B MENU \fIMenu_Name\fP {
.br
.B       \fIMenu_Item_Line\fP
.br
.B       \fIMenu_Item_Line\fP
.br
.B        \fI...\fP
.br
.B }
.br
This instruction defines a menu and asigns a \fIMenu_Name\fP to it.
\fIMenu_Item_Line\fP are lines  of any of the following types:
.TP 8
.B SEPARATOR
.TP 8
.B \fIItem_Label\fP  EXEC \fICommand\fP
.TP 8
.B \fIItem_Label\fP  MENU \fIpreviously-defined-menu-name\fP
.TP 8
.B \fIItem_Label\fP  ALWAYSONTOP
.TP 8
.B \fIItem_Label\fP  RELOAD
.br
The \fIItem_Label\fP is the string that is written in the menu item.
.br
\fICommand\fP is a string with the command that will be executed by /bin/sh.
Here paths should be \fICYGWIN\fP style (e.g. /usr/local/bin/myprogram).
A string "%display%" appearing in the \fICommand\fP will be replaced
with the proper display variable (i.e. 127.0.0.1:<display>.0).
.br
\fBALWAYSONTOP\fP sets the window to which the menu is associated to
display above all others.
.br
\fBRELOAD\fP causes the XWinrc file to be reloaded and icons and menus
regenerated.
.TP 8
.B ROOTMENU \fIpreviously-defined-menu-name\fP
Includes the items in the indicated menu into the menu associated with
\fIXWin\fP that appears in the system tray.
.TP 8
.B DEFAULTSYSMENU \fIpreviously-defined-menu-name\fP ATSTART|ATEND
Includes the items in the indicated menu into the menu associated with
generic top-level X-Windows in the \fIXWin\fP \fImultiwindow\fP mode.  The
keywords \fBATSTART\fP and \fBATEND\fP indicate if such items should be
included at the start or at the end of the menu.
.TP 8
.B SYSMENU {
  \fIclass-or-name-of-window\fP \fIdefined-menu-name\fP \fBATSTART|ATEND\fP
.br
  \fI...\fP
.br
  \fB}\fP
.br
Associates a specific menu to a specified window class or name
in \fI-multiwindow\fP mode. The keywords ATSTART or ATEND indicate if
such items should be included at the start or at the end of the menu.


.SH Icon Instructions
When specifying an \fIicon-file\fP in the following commands several different formats are allowed:
.br
\fB"NAME.ICO"\fP\fI of an .ico format file\fP
.br
\t \t ("cygwin.ico", "apple.ico")
.br
\fB"NAME.DLL,nn"\fP\fI of a .DLL and icon index\fP
.br
\t \t ("c:\\windows\\system32\\shell32.dll,4" is the default folder icon)
.br
\fB",nnn"\fP\fI index into XWin.EXE internal ICON resources\fP
.br
\t \t (",101" is the 1st icon inside \fIXWin.EXE\fP)
.TP 8
.B ICONDIRECTORY \fIWindows-path-to-icon-directory\fP
Defines the default directory to search for \ficon-file\fP files.
It should be a \fIWindows\fP style path (e.g. C:\\cygwin\\usr\\local\\icons).
.TP 8
.B DEFAULTICON \fIicon-file\fP
Defines a replacement for the standard X icon for applications without
specified icons.
.TP 8
.B ICONS {
.br
 \fIclass-or-name-of-window\fP \fIicon-file\fP
.br
  \fI...\fP
.br
  \fB}\fP
.br
Defines icon replacements windows matching the specified window class or names.
If multiple name or class matches occur for a window, only the first one
will be used.

.SH Style Instructions
.TP 8
.B STYLES {
\fIclass-or-name-of-window\fP \fIstyle-keyword-1\fP \fIstyle-keyword-2\fP \fIstyle-keyword-3\fP
.br
  \fI...\fP
.br
\fB}\fP

Associates specific styles to a specified window class or name
in \fI-multiwindow\fP mode.  If multiple class or name matches occur,
for a window, only the first one will be used.

The style keywords indicate the following:

\fIstyle-keyword-1\fP

\fBTOPMOST\fP
.br
Open the class or name above all NOTOPMOST Microsoft Windows
.br
\fBMAXIMIZE\fP
.br
Start the class or name fullscreen.
.br
\fBMINIMIZE\fP
.br
Start the class or name iconic.
.br
\fBBOTTOM\fP
.br
Open the class or name below all Windows windows.
.br

\fIstyle-keyword-2\fP

\fBNOTITLE\fP
.br
No Windows title bar, for the class or name.
.br
\fBOUTLINE\fP
.br
No Windows title bar and just a thin-line border, for the class or name.
.br
\fBNOFRAME\fP
.br
No Windows title bar or border, for the class or name.

\fIstyle-keyword-3\fP

\fBSKIPTASKBAR\fP
.br
Omit the class or name from being listed in the Windows taskbar.

Up to one keyword from each of these three groups can be used.  Not all
groups need be used, and the keywords can be given in any order.


.SH EXAMPLE
.TP 8
This example adds an Xterm menu item to the system tray icon
\fBMENU systray {
.br
\t xterm  EXEC "xterm -display %display% -sb -sl 999"
.br
\t SEPARATOR
.br
}
.br
ROOTMENU systray
\fP

.TP 8
This example makes an oclock window frameless in \fI-multiwindow\fP mode
\fBSTYLES {
.br
\t oclock NOFRAME
.br
}



.SH "SEE ALSO"
 XWin(1)


.SH AUTHOR
The XWinrc feature of XWin was written primarily by Earle F. Philhower
III.  Extended for style configuration by Colin Harrison.
