 %%% fr8hyph.ck
  %%
  %% 
  %% This file 7bit ascii. 
  %% It is NOT autonomous, since it uses the 
  %% coding-independant hyphenation file
  %% fr8hyph.src as source of the patterns.

  %% This file sets up 8bit French hyphenation patterns 
  %% from the coding independant fr8hyph.src, for use 
  %% with font systems using the Cork 1990 encoding 
  %% (series dc, ec etc.). It is also suitable for dm fonts and 
  %% other Cork-extended CM fonts, which may have \oe
  %% in either or both of the positions "1B (CM)
  %% or "F7 (Cork).  

  %% This polyvalence is achieved by admitting 
  %% patterns for both positions of \oe.  
  %% The position "1B is the ff ligature for the Cork norm
  %% which is never passed to TeX as a single character,
  %% (say by \ff). Note that, inversely, \oe is not to be typed 
  %% as  oe  for TeX; the latter does not cause a ligature

  %% If these circumstances change, this short file 
  %% can readily be altered.

  %% The grouping around the the body of this file
  %% assures that the net change induced 
  %% is to the hyphenation trie only.
  %% (Neglecting a dozen or so abandoned hash table entries.)

 \begingroup

 \catcode`\<=0
 \catcode`\>=12
 \lccode`\'=`\' %
 \def\set#1>#2{\edef\temp{\def\noexpand#1>{\string #2}
                      \catcode`#2=12\lccode`#2=`#2}\temp}


 %%% Table setting up the Cork encoding for French patterns
  %
 %% <ag> for <a-grave>
 \set<ag>^^e0  
 %% <eg> is <e-grave>
 \set<eg>^^e8 
 %% <ea> is <e-acute>
 \set<ea>^^e9 

 %% <ax> is <a-circumflex>
 \set<ax>^^e2 
 %% <ex> is <e-circumflex>
 \set<ex>^^ea 
 %% <ix> is <i-circumflex>
 \set<ix>^^ee 
 %% <ox> is <o-circumflex>
 \set<ox>^^f4 
 %% <ux> is <u-circumflex>
 \set<ux>^^fb 

 %% <id> is <i-dieresis>
 \set<id>^^ef 
 %% <od> is <o-dieresis>
 \set<od>^^f6 

 %% <cc> is <u-cedilla>
 \set<cc>^^e7 

 %% <oe> is <oe-ligature>
 \set<oe>^^f7 

 \input fr8hyph.src

 %%% Now the addition for the extended CM fonts.

 \set<oe>^^1b 

\patterns{%
 1c<oe> % mjf jun88
 1m<oe> % mjf jun88
 1n<oe> % mjf jun88 % JD+ (df jun92)
 1s<oe> % mjf jun88
 .d<ea>2s1<oe> % mjf jun88
 hyper<oe>2 % JD+ (df jun92)
 }

 \endgroup

 \endinput

