/*
 * Help.java
 *
 * Created on 14. November 2005, 19:11
 */
 
 /**
 *
 *  This class provides some helping routines.
 *
 * @author  Olle Nebendahl
 */

class Help
{
    static final int HEAD_FIRST=0;
    static final int TAIL_FIRST=1;
    
    public static void main(String[] args)
    {
        
        /*
        String[] tokens = args[1].split("\\*");
        int l = tokens.length;
        int i = 0;
        while(i<l)System.out.println("#"+tokens[i++]+"#");
        */
        
        System.out.println(match(args[0],args[1]));
    }
    
    public static boolean match(String s, String t)
    {
        if(s.equals(t))return true;
        if(s==null)return false;
        if(t==null)return true;
        if(s.length()>0&&t.equals("*"))return true;
        
        int p = t.indexOf('*');
        if(p==-1)return false;
        if(p==0)return match2(s,t);
        String prefix = t.substring(0,p);
        if(p>0)if(!s.startsWith(prefix))return false;
        
        s=s.substring(p);
        t=t.substring(p);

        //System.out.println(s);
        //System.out.println(t);
        
        return match2(s,t);
               
    }
    
    public static boolean match2(String s, String t)
    {
        //System.out.println("checking for end "+s);
        int p = t.lastIndexOf('*');
        String suffix=t.substring(p+1);
        //System.out.println("Suffix: "+suffix);
        if(!s.endsWith(suffix))return false;
        s=s.substring(0,s.length()-suffix.length());
        t=t.substring(1,t.length()-suffix.length());

        //System.out.println(s);
        //System.out.println(t);
        
        return match3(s,t);
    }
    
    public static boolean match3(String s, String t)
    {
        String[] tokens = t.split("\\*");
        int l = tokens.length;
        int i = 0;
        int p;
        while(i<l)
        {
            p=s.indexOf(tokens[i]);
            if(p==-1)return false;
            //System.out.println("found: "+tokens[i]);
            s=s.substring(p+tokens[i].length());
            i++;
        }
        return true;
    }
        
    public static String noPaths(String s)
    {
        return noPaths(noPaths(s,"\\"),"/");
    }
    
    public static String noPaths(String fileName, String delim)
    {
        int i = fileName.lastIndexOf(delim);
        if(i==-1)return fileName; 
        else return fileName.substring(i+1);
    }
    
    static int str2int(String s)
    {
        if(null==s)return 0;
        s=s.trim();
        if(s.equals(""))return 0;
        try
        {
            int i =Integer.decode(s).intValue();
        }
        catch (NumberFormatException e)
        {
            Logger.log("Tried to turn a malformed String into an Integer:"+e);
            return 0;
        }
        
        return Integer.decode(s).intValue();
    }
    
    static String noBlancs(String s)
    {
        //while(s.charAt(0)==' ')s=s.substring(1,s.length());
        //while(s.charAt(s.length()-1)==' ')s=s.substring(0,s.length()-2);
        return(new String(s.trim()));
    }
    static String intArrayToString(int[] a)
    {
        String result=new String();
        int i=a.length;
        int j=0;
        while(j<i)result+=" "+a[j++];
        return result;
    }
    
    static int[] refine(int[] a, int[] b) //alle aus b, die auch in a drinnen sind
    {
        ILL result=new ILL();
        int posA=0;
        int posB=0;
        int lengthA=a.length;
        int lengthB=b.length;
        
        while(posB<lengthB)
        {
            while(posA<lengthA)
            {
                if(a[posA]<b[posB])posA++;
                else break;
            }
            if(posA<lengthA)
            {
                if(a[posA]==b[posB])result.add(a[posA]);
                posB++;
            }
            else break;
        }
        return result.asArray(TAIL_FIRST);
    }


    static int[] exclude(int[] a, int[] b)// a ohne b
    {
        Logger.log(intArrayToString(a));    
        Logger.log(":");
        Logger.log(intArrayToString(b));    
      
        ILL result=new ILL();
        int posA=0;
        int posB=0;
        int lengthA=a.length;
        int lengthB=b.length;
        while(posA<lengthA&&posB<lengthB)
        {
            if(a[posA]<b[posB])  
            result.add(a[posA++]);
            else 
            {
                if(a[posA]==b[posB]){  posA++;posB++; }
                else posB++;
            }
        }
        //while(posB<lengthB)result.add(b[posB++]);
        while(posA<lengthA)result.add(a[posA++]);
        //System.out.println("=");
        //System.out.println(result.asArray(TAIL_FIRST));    
        return result.asArray(TAIL_FIRST);
    }
    

    
    static int[] combine(int[] a, int[] b)
    {
        ILL result=new ILL();
        int posA=0;
        int posB=0;
        int lengthA=a.length;
        int lengthB=b.length;
        while(posA<lengthA&&posB<lengthB)
        {
            if(a[posA]<b[posB])  
            result.add(a[posA++]);
            else 
            {
                result.add(b[posB]);
                if(a[posA]==b[posB]){  posA++;posB++; }
                else posB++;
            
            }
        }
        while(posB<lengthB)result.add(b[posB++]);
        while(posA<lengthA)result.add(a[posA++]);
        return result.asArray(TAIL_FIRST);
    }  
}


/*  public static void malin( String[] argv )
    {
    String treiber=null, DbUrl=null ;

    //*** "Name des Datenbanktreibers eingeben
    treiber = "org.gjt.mm.mysql.Driver" ;
    //*** "Url der Databank eingeben *********
    //*** Server : linux
    //*** Service-Nummer : 3306
    //*** Bezeichnung der Datenbank : test1
    DbUrl = "jdbc:mysql://localhost:3306/test1" ;

     try {
         //*** Treiber laden ***********************************
         Class.forName( treiber ).newInstance();
          //*** Verbindung aufnehmen:    ************************
          //*** Der User peter mit Kennwort jpd0815 mcht was wissen
         Connection cn = DriverManager.getConnection( DbUrl, "peter", "jpd0815" );
         BufferedReader in = new BufferedReader(
                             new InputStreamReader( System.in ) );
        String frage = null ;
        while( true )
            {  //*** Endlosschleife fr die Abfragen *****************
             System.out.println( "Verbindung steht!!" );
             System.out.println( "Gib Deine Anfrage ein!!") ;
             System.out.println( "Beenden, wenn Du stop eingibst!!" ) ;
             frage = in.readLine() ;
             if( frage.equals( "stop" ) ) break ;
             try { //*** Anfrage  - Fehler abfangen **********************
                 Statement  st = cn.createStatement();
                 ResultSet  rs = st.executeQuery( frage );
                 ResultSetMetaData rsmd = rs.getMetaData();
                 int n, nmax = rsmd.getColumnCount();
                 System.out.println("----------- Antwort -------------------") ;
                 while( rs.next() )
                    { //**** SchauMerMal  Primitive Ausgabe    **********
                    for( n=1 ; n<=nmax ; n++ )
                    {
                       System.out.print( rs.getString( n )  ) ;
                    }
                    System.out.println() ;
                    }
                 System.out.println("----------- Antwort -------------------") ;
                 rs.close();
                 st.close();
                 } catch( SQLException ex )
                         {  System.out.println( ex );   }
            }
        cn.close();
        } catch( Exception ex ) {   System.out.println( ex );   }
   }
*/
