//\frame{Dies knnte ein Titel sein}{
import java.io.*;
import java.util.*;


public class PTD {
  private FileInputStream file;
  private StreamTokenizer st;
  private int slideCount;
  private int chunkCount;
  private int actualChunk;
  private int sourceChunk;
  private int titleChunk;
  private ILL foundSlides;
  private String frameSyntax="frame";

  public int getSlideCount(){return slideCount;};

    PTD(String s, String s2, int i, int j, int k)throws FileNotFoundException
    {
        this(s,i,j,k);
        frameSyntax=s2;
        chunkCount=i;
        sourceChunk=k;
        titleChunk=j;
    }
  
    PTD(String s, int i, int j, int k)throws FileNotFoundException
    {
        this(s);
        chunkCount=i;
        sourceChunk=k;
        titleChunk=j;
    }

  PTD(String filename)
    throws FileNotFoundException {
    try {
      file = new FileInputStream(filename);
      st = new StreamTokenizer(file);
      


      st.resetSyntax();
      st.eolIsSignificant(true);
      st.wordChars(48,57);
      st.wordChars(65,90);
      st.wordChars(97,122);
      
      st.ordinaryChars(32,32);
      st.ordinaryChar('{');
      st.ordinaryChar('}');
      st.ordinaryChar('\'');
      
      chunkCount=2;
      sourceChunk=2;
      titleChunk=1;

      
    } catch(FileNotFoundException e) {
      System.out.println(
        "Could not open " + filename);
      throw e;
    }
  }
  
  void cleanup() {
    try {
      file.close();
    } catch(IOException e) {
      System.out.println(
        "file.close() unsuccessful");
    }
  }
  
  void showHappen() {
    try {
    
      foundSlides=new ILL();
      rezinekoT saveTokens = new rezinekoT();
      SlideWrapper newSlide= new SlideWrapper();
    
      boolean withinSlide=false;
      boolean commentRow=false;
      boolean commentRowEnd=false;
      
      int openedBrackets=0;
      int closedBrackets=0;
      
      slideCount=0;

      
      String lastString="";
      String s="";
      
      while(st.nextToken() != StreamTokenizer.TT_EOF) 
      {
        lastString=s;
        switch(st.ttype) {
          case StreamTokenizer.TT_EOL:
            s = new String("\n");
            commentRowEnd=true;
            break;
       /*   case StreamTokenizer.TT_NUMBER:
            s = Double.toString(st.nval);
            System.out.println("Here Number!!!!!!!!!");
            break; */
          case StreamTokenizer.TT_WORD:
            s = st.sval; // Already a String
            break;
          default: // single character in ttype
            s = String.valueOf((char)st.ttype);

            // hier werden die geffneten und schlieenden geschwungenen Klammern gezhlt
            // und LaTeX-Kommentare bercksichtigt
              if (withinSlide&&s.equals("{")&&!lastString.equals("\\")&&!commentRow) 
              {  
                openedBrackets++;
                if(openedBrackets==1)continue; // %\frame{-Klammer ->weg
              }
              else
              if (withinSlide&&s.equals("}")&&!lastString.equals("\\")&&!commentRow) closedBrackets++;
              else
              if (s.equals("%")&&!lastString.equals("\\")&&!commentRow)
              {
                commentRow=true;
                commentRowEnd=false;
                // debug mode System.out.println("commentstart");
              }
            
        }
        if(!withinSlide&&s.equals(frameSyntax)&&lastString.equals("\\")&&!commentRow)
        {
          //           debug mode           
          System.out.println("****************************framestart");
          
          actualChunk=1;
          
          newSlide=new SlideWrapper(Constants.NO_SLIDE_ID);
          saveTokens.reset(newSlide.getId());
          
          slideCount++;
          
          withinSlide=true;
          
          openedBrackets=0;
          closedBrackets=0;
        }
        if(withinSlide&&(openedBrackets==closedBrackets)&&(openedBrackets>0))
        {  

          SlideConnection.doSqlUpdate(saveTokens.getWordTokens());
          SlideConnection.doSqlUpdate(saveTokens.getWordSlidePairs());
          if(actualChunk==sourceChunk)
            newSlide.setSource(saveTokens.getSlideText());
          else
          if(actualChunk==titleChunk) 
            newSlide.setTitle(saveTokens.getSlideText());
          else  
            newSlide.setAnnotation(saveTokens.getSlideText());
          if(actualChunk==chunkCount)
          { withinSlide=false;
          // System.out.println("");
          // debug mode 
            System.out.println("############################framestopp");
            SlideConnection.doSqlUpdate("insert into searchindex select wordid,slideid from wordindex, tempsearchindex where wordindex.word=tempsearchindex.word");
            SlideConnection.doSqlUpdate("delete from tempsearchindex where true");
            newSlide.flush();
            foundSlides.add(newSlide.getId());
            
          }
          else
          {
            actualChunk++;
            saveTokens.resetSlideText();
            openedBrackets=0;
            closedBrackets=0;
          }
            
                        
        }
        if(withinSlide&&openedBrackets>0)
        {
          System.out.print(s);// debug mode else System.out.print("["+s+"]");
          saveTokens.feed(s);
        }
//        if(withinSlide&&openedBrackets>0)if(s.length()>2)SlideConnection.doMySqlUpdate("insert ignore into wordindex (word) values (\""+s+"\");");
//        if(s.length()>2)System.out.println("insert into wordindex (word) values (\""+s+"\");");


        if(commentRow&&commentRowEnd)commentRow=false;
        //System.out.print("["+s+"]");
      }
//    System.out.println("");  
    System.out.println(slideCount+"Folien gefunden.");

      
    } catch(IOException e) {
      System.out.println(
        "st.nextToken() unsuccessful");
    }
    
  }

  public static void main(String[] args) {
    try {
      PTD wc =
        new PTD(args[0],Integer.decode(args[1]).intValue(),Integer.decode(args[2]).intValue(),Integer.decode(args[3]).intValue());
      wc.showHappen();
      wc.cleanup();
    } catch(Exception e) {
      System.out.println("usage: java PTD filename chunkCount titleChunk sourceChunk");
      e.printStackTrace();
    }
  }
}
//}
