/* vscroll.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <stdlib.h>
#include <sys/video.h>
#include "video2.h"
#include "video3.h"

#if defined (IF_WIN32)
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif

void v_scroll (int tl_x, int tl_y, int br_x, int br_y, int count, int flag)
{
  if (count > 0)
    {
#if defined (IF_WIN32)
      IF_WIN32
	{

	  SMALL_RECT sr;
	  COORD cc;
	  CHAR_INFO pi;

	  sr.Left = tl_x;
	  sr.Top = tl_y;
	  sr.Right = br_x;
	  sr.Bottom = br_y;
	  pi.Char.AsciiChar = ' ';
	  pi.Attributes = _v_attr;

	  if (flag == V_SCROLL_CLEAR)
	  {
	    V_SCROLL_DOWN;
	    count = 0xfff;
	  }

	  switch (flag)
	  {
	    case V_SCROLL_UP:
	      cc.X = tl_x;
	      cc.Y = tl_y - count;
	      break;

	    case V_SCROLL_DOWN:
	      cc.X = tl_x;
	      cc.Y = tl_y + count;
	      break;

	    case V_SCROLL_LEFT:
	      cc.X = tl_x - count;
	      cc.Y = tl_y;
	      break;

	    case V_SCROLL_RIGHT:
	      cc.X = tl_x + count;
	      cc.Y = tl_y;
	      break;
	  }

	  ScrollConsoleScreenBuffer(
		GetStdHandle(STD_OUTPUT_HANDLE),
		&sr,
		NULL,
		cc,
		&pi);

	}
#endif
#if defined (IF_DOS)
      IF_DOS
	{
	  union REGS r;

	  r.h.al = count;
	  switch (flag)
	    {
	    case V_SCROLL_UP:
	      r.h.ah = 0x06;
	      break;
	    case V_SCROLL_DOWN:
	      r.h.ah = 0x07;
	      break;
	    case V_SCROLL_LEFT:
	    case V_SCROLL_RIGHT:
	      return;
	    case V_SCROLL_CLEAR:
	      r.h.ah = 0x06;
	      r.h.al = 0;
	      break;
	    }
	  r.h.cl = (unsigned char)tl_x;
	  r.h.ch = (unsigned char)tl_y;
	  r.h.dl = (unsigned char)br_x;
	  r.h.dh = (unsigned char)br_y;
	  r.h.bh = (unsigned char)_v_attr;
	  _int86 (0x10, &r, &r);
	}
#endif
    }
}
