#include <stdio.h>
#include <strings.h>
#include <math.h>

int mquad(p)
unsigned char *p;
{
	unsigned int cc;

	cc = (((unsigned int)p[0]*256
		+(unsigned int)p[1])*256
		+(unsigned int)p[2])*256
		+(unsigned int)p[3];

	return(cc);
}

unsigned int utri(p)
unsigned char *p;
{
	unsigned int i,cc;
	unsigned char fchar[4];

	fchar[0] = 0;
	for (i = 1 ; i < 4 ; i++)
		fchar[i] = p[i-1];

	cc = mquad(fchar);

	return cc;
}

int tri(p)
unsigned char *p;
{
	int i,cc;
	unsigned char fchar[4];

	fchar[0] = 0;
	for (i = 1 ; i < 4 ; i++)
		fchar[i] = p[i-1];

	cc = mquad(fchar);

	if (cc > 8388607) cc -= 16777216;
	return cc;
}

unsigned int upair(p)
unsigned char *p;
{
	unsigned int i,cc;
	unsigned char fchar[4];

	fchar[0] = fchar[1] = 0;
	for (i = 2 ; i < 4 ; i++)
		fchar[i] = p[i-2];

	cc = mquad(fchar);

	return cc;
}

int pair(p)
unsigned char *p;
{
	int i,cc;
	unsigned char fchar[4];

	fchar[0] = fchar[1] = 0;
	for (i = 2 ; i < 4 ; i++)
		fchar[i] = p[i-2];

	cc = mquad(fchar);

	if (cc > 32767) cc -= 65536;
	return cc;
}

int mget(p,num)
char *p;
int num;
{
	switch (num) {
	case 1:
		return *p;
		break;
	case 2:
		return pair(p);
		break;
	case 3:
		return tri(p);
		break;
	case 4:
		return mquad(p);
		break;
	}
}

int fquad(fp)
FILE *fp;
{
	int i,cc;
	unsigned char fchar[4];

	for (i = 0 ; i < 4 ; i++)
		fchar[i] = fgetc(fp);

	cc = mquad(fchar);
	return cc;
}

unsigned int uftri(fp)
FILE *fp;
{
	unsigned int i,cc;
	unsigned char fchar[4];

	fchar[0] = 0;
	for (i = 1 ; i < 4 ; i++)
		fchar[i] = fgetc(fp);

	cc = mquad(fchar);

	return cc;
}

int ftri(fp)
FILE *fp;
{
	int i,cc;
	unsigned char fchar[4];

	fchar[0]=0;
	for (i=1;i<4;i++)
		fchar[i]=fgetc(fp);

	cc = mquad(fchar);

	if (cc > 8388607) cc -= 16777216;

	return cc;
}

unsigned int ufpair(fp)
FILE *fp;
{
	unsigned int i,cc;
	unsigned char fchar[4];

	fchar[0] = fchar[1] = 0;
	for (i = 2 ; i < 4 ; i++)
		fchar[i] = fgetc(fp);

	cc = mquad(fchar);

	return cc;
}

int fpair(fp)
FILE *fp;
{
	int i,cc;
	unsigned char fchar[4];

	fchar[0] = fchar[1] = 0;
	for (i = 2 ; i < 4 ; i++)
		fchar[i] = fgetc(fp);

	cc = mquad(fchar);

	if (cc > 32767) cc -= 65536;

	return cc;
}

int fskip(fp,num)
FILE *fp;
int num;
{
	fseek(fp,num,1);
}

int fputnum(num,byte,fp)
int num,byte;
FILE *fp;
{
	int i,cc;
	char buf[16];

	for (i = byte-1 ; i >= 0 ; i--) {
		buf[i] = num & 0xff;
		num >>= 8;
	}

	for (i = 0 ; i < byte ; i++) {
		fputc(buf[i],fp);
	}

	return 0;
}

int numcount(num)
int num;
{
	if (num >= 0) {
		if (num <= 255) {
			return 1;
		}
		else if (num <= 65535) {
			return 2;
		}
		else if (num <= 1677215) {
			return 3;
		}
		else {
			return 4;
		}
	}
	else {
		if (num >= -256) {
			return 1;
		}
		else if (num >= -65536) {
			return 2;
		}
		else if (num >= -1677216) {
			return 3;
		}
		else {
			return 4;
		}
	}
}

int fputnum2(num,fp)
int num;
FILE *fp;
{
	if (num >= 0) {
		if (num <= 255) {
			fputnum(num,1,fp);
		}
		else if (num <= 65535) {
			fputnum(num,2,fp);
		}
		else if (num <= 1677215) {
			fputnum(num,3,fp);
		}
		else {
			fputnum(num,4,fp);
		}
	}
	else {
		if (num >= -256) {
			fputnum(num,1,fp);
		}
		else if (num >= -65536) {
			fputnum(num,2,fp);
		}
		else if (num >= -1677216) {
			fputnum(num,3,fp);
		}
		else {
			fputnum(num,4,fp);
		}
	}
}

int fputstr(str,byte,fp)
char *str;
int byte;
FILE *fp;
{
	int i;

	for (i = 0 ; i < byte ; i++) {
		fputc(str[i],fp);
	}

	return 0;
}
int cutspace(fp)
FILE *fp;
{
	int cc;

	cc = fgetc(fp);
	if (cc == ';') {
		ungetc(cc,fp);
		return 0;
	}
	if (cc != ' ' && cc != '\t' && cc != '\n' && cc != '\0') return -1;
	while (1) {
		cc = fgetc(fp);
		if (cc == EOF) return -1;
		if (cc != ' ' && cc != '\t' && cc != '\n' && cc != '\0') {
			ungetc(cc,fp);
			return 0;
		}
	}
}

int gethex(fp)
FILE *fp;
{
	int cc,i;
	char buf[256];

	if (fgetc(fp) != '<') {
		return -1;
	}

	for (i = 0 ; ; i++) {
		cc = fgetc(fp);
		if ((cc >= '0'  && cc <= '9') || (cc >= 'a' && cc <= 'f') || (cc >= 'A' && cc <= 'F')) {
			buf[i] = cc;
		}
		else if (cc == '>') {
			buf[i] = '\0';
			return strtol(buf,NULL,16);
		}
		else {
			return -1;
		}
	}
}

int getdec(fp)
FILE *fp;
{
	int cc,i;
	char buf[256];

	for (i = 0 ; ; i++) {
		cc = fgetc(fp);
		if ((cc >= '0'  && cc <= '9') || cc == '-') {
			buf[i] = cc;
		}
		else if (cc == ' ' || cc == '\t' || cc == '\n' || cc == '\0' || cc == EOF) {
			ungetc(cc,fp);
			buf[i] = '\0';
			return atoi(buf);
		}
		else return -1;
	}
}
