#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "alias.h"

#define LINE_MAX 256

static unsigned int hash_func(key)
     char *key;
{
  unsigned int h = 0;
  while (*key) h ^= *key++;
  return h % ALIAS_HASH_SIZE;
}

AliasMap *read_aliasmap(filename)
     char *filename;
{
  FILE *fp;
  char buf[LINE_MAX+1];
  AliasMap *map;
  int i;
  
  fp = fopen(filename,"r");
  if (fp == NULL) {
    fprintf(stderr,"%s: cannot read.\n",filename);
    return NULL;
  }
  map = (AliasMap*)malloc(sizeof(AliasMap));
  if (map == NULL) {
  no_mem:
    fprintf(stderr,"memory exhausted.\n");
    exit(1);
  }
  for (i=0;i<ALIAS_HASH_SIZE;i++)
    map->hash_table[i] = NULL;
  while (fgets(buf,LINE_MAX,fp)) {
    unsigned int h;
    char *key,*val,*p;
    alias_hash_item *item;
    for (val=buf;*val && isspace(*val);val++) ;
    if (*val == '%' || !*val) continue; /* comment or empty line */
    for (key = val;*key && !isspace(*key);key++) ;
    if (!*key) continue; /* no key */
    *key++ = '\0';
    while (*key && isspace(*key)) key++;
    if (!*key) continue; /* no key */
    for (p=key;*p && !isspace(*p);p++) ;
    *p = '\0';
    item = (alias_hash_item*)malloc(sizeof(alias_hash_item));
    if (item == NULL) goto no_mem;
    item->key = strdup(key);
    item->value = strdup(val);
    if (item->key == NULL || item->value == NULL) goto no_mem;
    h = hash_func(key);
    item->next = map->hash_table[h];
    map->hash_table[h] = item;
  }
  fclose(fp);
  return map;
}

char *refer_aliasmap(map,key)
     AliasMap *map;
     char *key;
{
  unsigned int h = hash_func(key);
  alias_hash_item *item = map->hash_table[h];
  while (item != NULL) {
    if (strcmp(item->key,key) == 0) return item->value;
    item = item->next;
  }
  return key;
}

#ifdef TEST
char *test_string[] = {
  "string1","string2","string3",NULL,
};

void
test_func(name)
     char *name;
{
  AliasMap *map;
  char **p = test_string;
  map = read_aliasmap(name);
  if (map == NULL) {
    return;
  }
  while (*p) {
    char *s = refer_aliasmap(map,*p);
    printf("%s -> %s\n",*p,s);
    p++;
  }
}

int main(argc,argv)
     int argc;
     char *argv[];
{
  if (argc < 2) {
    test_func("texfonts.map");
  }
  else {
    int i;
    for (i=1;i<argc;i++) {
      test_func(argv[i]);
    }
  }
  return 0;
}
#endif
